/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.Wrapped;
import net.amygdalum.testrecorder.util.GenericObjectException;

public abstract class GenericObject {
    public <T> T as(Class<T> clazz) {
        return this.as(GenericObject.newInstance(clazz));
    }

    public static <T> T newInstance(Class<T> clazz) {
        Exception exception = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            boolean access = constructor.isAccessible();
            if (!access) {
                constructor.setAccessible(true);
            }
            for (Supplier<Object[]> params : GenericObject.bestParams(constructor.getParameterTypes())) {
                try {
                    Object instance = constructor.newInstance(params.get());
                    return (T)instance;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    exception = e;
                }
                catch (RuntimeException e) {
                }
            }
            if (access) continue;
            constructor.setAccessible(false);
        }
        throw new GenericObjectException(exception);
    }

    private static Iterable<Supplier<Object[]>> bestParams(Class<?>[] parameterTypes) {
        if (parameterTypes.length == 0) {
            return Arrays.asList(() -> new Object[0]);
        }
        return Arrays.asList(() -> GenericObject.createDefaultParams(parameterTypes), () -> GenericObject.createNonNullParams(parameterTypes), () -> GenericObject.createNonDefaultParams(parameterTypes));
    }

    public static Object[] createDefaultParams(Class<?>[] classes) {
        Object[] params = new Object[classes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = GenericObject.getDefaultValue(classes[i]);
        }
        return params;
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        return null;
    }

    public static Object[] createNonNullParams(Class<?>[] classes) {
        Object[] params = new Object[classes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = GenericObject.getNonNullValue(classes[i]);
        }
        return params;
    }

    public static Object getNonNullValue(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }
        return GenericObject.newInstance(clazz);
    }

    public static Object[] createNonDefaultParams(Class<?>[] classes) {
        Object[] params = new Object[classes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = GenericObject.getNonDefaultValue(classes[i]);
        }
        return params;
    }

    public static Object getNonDefaultValue(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0001');
        }
        if (clazz == Byte.TYPE) {
            return (byte)1;
        }
        if (clazz == Short.TYPE) {
            return (short)1;
        }
        if (clazz == Integer.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(1.0f);
        }
        if (clazz == Long.TYPE) {
            return 1L;
        }
        if (clazz == Double.TYPE) {
            return 1.0;
        }
        return GenericObject.getNonNullValue(clazz);
    }

    public <T> T as(Supplier<T> constructor) {
        return this.as(constructor.get());
    }

    public Wrapped as(Wrapped wrapped) {
        for (Field field : this.getGenericFields()) {
            try {
                wrapped.setField(field.getName(), field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new GenericObjectException(e);
            }
        }
        return wrapped;
    }

    public <T> T as(T o) {
        for (Field field : this.getGenericFields()) {
            try {
                GenericObject.setField(o, field.getName(), field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new GenericObjectException(e);
            }
        }
        return o;
    }

    public static void setField(Object o, String name, Object value) {
        if (value instanceof Wrapped) {
            value = ((Wrapped)value).value();
        }
        Field to = GenericObject.findField(name, o.getClass());
        GenericObject.setField(o, to, value);
    }

    public static void setField(Object o, Field to, Object value) {
        boolean access = to.isAccessible();
        if (!access) {
            to.setAccessible(true);
        }
        try {
            to.set(o, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new GenericObjectException(e);
        }
        finally {
            if (!access) {
                to.setAccessible(false);
            }
        }
    }

    public static void copyArrayValues(Object from, Object to) {
        int toLength;
        int fromLength = Array.getLength(from);
        int minLength = fromLength < (toLength = Array.getLength(to)) ? fromLength : toLength;
        for (int i = 0; i < minLength; ++i) {
            Object value = Array.get(from, i);
            Array.set(to, i, value);
        }
    }

    public static void copyField(Field field, Object from, Object to) {
        boolean access = field.isAccessible();
        if (!access) {
            field.setAccessible(true);
        }
        try {
            Object value = field.get(from);
            field.set(to, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new GenericObjectException(e);
        }
        finally {
            if (!access) {
                field.setAccessible(false);
            }
        }
    }

    public static Field findField(String name, Class<?> clazz) {
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new GenericObjectException(new NoSuchFieldException(name));
    }

    public List<Field> getGenericFields() {
        Field[] declaredFields = this.getClass().getDeclaredFields();
        return Stream.of(declaredFields).filter(field -> this.isSerializable((Field)field)).map(field -> {
            field.setAccessible(true);
            return field;
        }).collect(Collectors.toList());
    }

    private boolean isSerializable(Field field) {
        return !field.isSynthetic() && field.getName().indexOf(36) < 0 && (field.getModifiers() & 8) != 8 && (field.getModifiers() & 0x10) != 16;
    }
}

