/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.amygdalum.testrecorder.Serializer;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SerializerFactory;
import net.amygdalum.testrecorder.values.SerializedSet;

public class DefaultSetSerializer
implements Serializer<SerializedSet> {
    private SerializerFacade facade;

    public DefaultSetSerializer(SerializerFacade facade) {
        this.facade = facade;
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return Arrays.asList(HashSet.class, LinkedHashSet.class);
    }

    @Override
    public SerializedSet generate(Type type, Class<?> valueType) {
        return new SerializedSet(type, valueType);
    }

    @Override
    public void populate(SerializedSet serializedObject, Object object) {
        for (Object element : (Set)object) {
            serializedObject.add(this.facade.serialize(element.getClass(), element));
        }
    }

    public static class Factory
    implements SerializerFactory<SerializedSet> {
        public DefaultSetSerializer newSerializer(SerializerFacade facade) {
            return new DefaultSetSerializer(facade);
        }
    }
}

