/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.amygdalum.testrecorder.data.TestDataGenerator;
import net.amygdalum.testrecorder.data.TestValueGenerator;

public class GenericObjectGenerator<T>
implements TestValueGenerator<T> {
    private Class<T> clazz;

    public GenericObjectGenerator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T create(TestDataGenerator generator) {
        T instance = this.makeInstance(generator);
        for (Class<T> current = this.clazz; current != Object.class; current = current.getSuperclass()) {
            this.generateFields(generator, instance, current);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T makeInstance(TestDataGenerator generator) {
        try {
            return this.clazz.newInstance();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
                boolean accessible = constructor.isAccessible();
                try {
                    if (!accessible) {
                        constructor.setAccessible(true);
                    }
                    Object[] args = this.createArgs(generator, constructor.getParameterTypes());
                    Object obj = constructor.newInstance(args);
                    return (T)obj;
                }
                catch (ReflectiveOperationException reflectiveOperationException2) {
                }
                finally {
                    if (!accessible) {
                        constructor.setAccessible(false);
                    }
                }
            }
            return null;
        }
    }

    private Object[] createArgs(TestDataGenerator generator, Class<?>[] parameterTypes) {
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = generator.create(this.clazz);
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFields(TestDataGenerator generator, T instance, Class<?> current) {
        for (Field field : current.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(instance, generator.create(field.getType()));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
    }
}

