/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.ContextSnapshot;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.SnapshotConsumer;
import net.amygdalum.testrecorder.SnapshotGenerator;
import net.amygdalum.testrecorder.util.ExpectedOutput;
import net.amygdalum.testrecorder.util.IORecorder;
import net.amygdalum.testrecorder.util.RecordInput;
import net.amygdalum.testrecorder.util.RecordOutput;
import net.amygdalum.testrecorder.util.SetupInput;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedInput;
import net.amygdalum.testrecorder.values.SerializedOutput;
import net.amygdalum.testrecorder.visitors.Computation;
import net.amygdalum.testrecorder.visitors.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.visitors.ObjectToMatcherCode;
import net.amygdalum.testrecorder.visitors.ObjectToSetupCode;
import net.amygdalum.testrecorder.visitors.SerializedValueVisitorFactory;
import net.amygdalum.testrecorder.visitors.Templates;
import net.amygdalum.testrecorder.visitors.TypeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.stringtemplate.v4.ST;

public class TestGenerator
implements SnapshotConsumer {
    private static final Set<Class<?>> IMMUTABLE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class, String.class));
    private static final String RECORDED_TEST = "RecordedTest";
    private static final String TEST_FILE = "package <package>;\n\n<imports: {pkg | import <pkg>;\n}>\n\n\n<runner>public class <className> {\n\n  <fields; separator=\"\\n\">\n\n  <before>\n\n  <methods; separator=\"\\n\">\n}";
    private static final String RUNNER = "@RunWith(<runner>.class)\n";
    private static final String RECORDED_INPUT = "@RecordInput({<classes : {class | \"<class>\"};separator=\", \">})\n";
    private static final String RECORDED_OUTPUT = "@RecordOutput({<classes : {class | \"<class>\"};separator=\", \">})\n";
    private static final String BEFORE_TEMPLATE = "@Before\npublic void before() throws Exception {\n  <statements;separator=\"\\n\">\n}\n";
    private static final String TEST_TEMPLATE = "@Test\npublic void test<testName>() throws Exception {\n  <statements;separator=\"\\n\">\n}\n";
    private static final String BEGIN_ARRANGE = "\n//Arrange";
    private static final String BEGIN_ACT = "\n//Act";
    private static final String BEGIN_ASSERT = "\n//Assert";
    private TypeManager types = this.initTypes();
    private SerializedValueVisitorFactory setup = new ObjectToSetupCode.Factory();
    private SerializedValueVisitorFactory matcher = new ObjectToMatcherCode.Factory();
    private Map<Class<?>, Set<String>> tests;
    private Set<String> fields;
    private Set<String> inputClasses;
    private Set<String> outputClasses;
    private Class<? extends Runnable> initializer;

    public TestGenerator(Class<? extends Runnable> initializer) {
        this.initializer = initializer;
        this.tests = Collections.synchronizedMap(new LinkedHashMap());
        this.fields = new LinkedHashSet<String>();
        this.inputClasses = new LinkedHashSet<String>();
        this.outputClasses = new LinkedHashSet<String>();
    }

    private TypeManager initTypes() {
        TypeManager types = new TypeManager();
        types.registerTypes(new Type[]{Test.class});
        return types;
    }

    public String generateBefore(List<String> statements) {
        ST test = new ST(BEFORE_TEMPLATE);
        test.add("statements", statements);
        return test.render();
    }

    public void setSetup(SerializedValueVisitorFactory setup) {
        this.setup = setup;
    }

    public void setMatcher(SerializedValueVisitorFactory matcher) {
        this.matcher = matcher;
    }

    @Override
    public void accept(ContextSnapshot snapshot) {
        Set localtests = this.tests.computeIfAbsent(TypeManager.getBase(snapshot.getThisType()), key -> new LinkedHashSet());
        MethodGenerator methodGenerator = new MethodGenerator(snapshot, localtests.size()).generateArrange().generateAct().generateAssert();
        localtests.add(methodGenerator.generateTest());
    }

    public void writeResults(Path dir) {
        for (Class<?> clazz : this.tests.keySet()) {
            String rendered = this.renderTest(clazz);
            try {
                Path testfile = this.locateTestFile(dir, clazz);
                BufferedWriter writer = Files.newBufferedWriter(testfile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                Throwable throwable = null;
                try {
                    writer.write(rendered);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                System.out.println(rendered);
            }
        }
    }

    public void clearResults() {
        this.types = this.initTypes();
        this.tests.clear();
        this.fields = new LinkedHashSet<String>();
        this.inputClasses = new LinkedHashSet<String>();
        this.outputClasses = new LinkedHashSet<String>();
    }

    private Path locateTestFile(Path dir, Class<?> clazz) throws IOException {
        String pkg = clazz.getPackage().getName();
        String className = this.computeClassName(clazz);
        Path testpackage = dir.resolve(pkg.replace('.', '/'));
        Files.createDirectories(testpackage, new FileAttribute[0]);
        return testpackage.resolve(className + ".java");
    }

    public Set<String> testsFor(Class<?> clazz) {
        return this.tests.getOrDefault(clazz, Collections.emptySet());
    }

    public String renderTest(Class<?> clazz) {
        Set<String> localtests = this.testsFor(clazz);
        ST file = new ST(TEST_FILE);
        file.add("package", (Object)clazz.getPackage().getName());
        file.add("runner", (Object)this.computeRunner());
        file.add("className", (Object)this.computeClassName(clazz));
        file.add("fields", this.fields);
        file.add("before", (Object)this.computeBefore());
        file.add("methods", localtests);
        file.add("imports", this.types.getImports());
        return file.render();
    }

    private String computeRunner() {
        if (this.outputClasses.isEmpty() && this.inputClasses.isEmpty()) {
            return null;
        }
        if (this.initializer != null) {
            if (!this.outputClasses.isEmpty()) {
                this.outputClasses.add(this.initializer.getTypeName());
            }
            if (!this.inputClasses.isEmpty()) {
                this.inputClasses.add(this.initializer.getTypeName());
            }
        }
        ST runner = new ST(RUNNER);
        runner.add("runner", (Object)IORecorder.class.getSimpleName());
        ST recordedInput = new ST(RECORDED_INPUT);
        recordedInput.add("classes", this.inputClasses);
        ST recordedOutput = new ST(RECORDED_OUTPUT);
        recordedOutput.add("classes", this.outputClasses);
        return runner.render() + (this.inputClasses.isEmpty() ? "" : recordedInput.render()) + (this.outputClasses.isEmpty() ? "" : recordedOutput.render());
    }

    private String computeBefore() {
        this.types.registerType((Type)((Object)Before.class));
        if (this.initializer == null) {
            return "";
        }
        this.types.registerType(this.initializer);
        String initObject = Templates.newObject(this.types.getSimpleName(this.initializer), new String[0]);
        String initStmt = Templates.callMethodStatement(initObject, "run", new String[0]);
        return this.generateBefore(Arrays.asList(initStmt));
    }

    public String computeClassName(Class<?> clazz) {
        return clazz.getSimpleName() + RECORDED_TEST;
    }

    public static TestGenerator fromRecorded(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField("generator");
            field.setAccessible(true);
            SnapshotGenerator generator = (SnapshotGenerator)field.get(object);
            return (TestGenerator)generator.getMethodConsumer();
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            return null;
        }
    }

    private class MethodGenerator {
        private LocalVariableNameGenerator locals;
        private ContextSnapshot snapshot;
        private int no;
        private List<String> statements;
        private String base;
        private List<String> args;
        private String result;

        public MethodGenerator(ContextSnapshot snapshot, int no) {
            this.snapshot = snapshot;
            this.no = no;
            this.locals = new LocalVariableNameGenerator();
            this.statements = new ArrayList<String>();
        }

        public MethodGenerator generateArrange() {
            List<SerializedInput> serializedInput;
            this.statements.add(TestGenerator.BEGIN_ARRANGE);
            List<SerializedOutput> serializedOutput = this.snapshot.getExpectOutput();
            if (serializedOutput != null && !serializedOutput.isEmpty()) {
                TestGenerator.this.types.registerTypes(new Type[]{RunWith.class, RecordOutput.class, IORecorder.class, ExpectedOutput.class});
                TestGenerator.this.fields.add(Templates.fieldDeclaration("public", ExpectedOutput.class.getSimpleName(), "expectedOutput"));
                ArrayList<String> methods = new ArrayList<String>();
                for (SerializedOutput serializedOutput2 : serializedOutput) {
                    TestGenerator.this.types.registerImport(serializedOutput2.getDeclaringClass());
                    TestGenerator.this.outputClasses.add(serializedOutput2.getDeclaringClass().getTypeName());
                    List args = Stream.of(serializedOutput2.getValues()).map(arg -> arg.accept(TestGenerator.this.matcher.create(this.locals, TestGenerator.this.types))).collect(Collectors.toList());
                    this.statements.addAll(args.stream().flatMap(arg -> arg.getStatements().stream()).collect(Collectors.toList()));
                    List<String> arguments = Stream.concat(Arrays.asList(Templates.classOf(serializedOutput2.getDeclaringClass().getSimpleName()), Templates.stringOf(serializedOutput2.getName())).stream(), args.stream().map(arg -> arg.getValue())).collect(Collectors.toList());
                    methods.add(Templates.callLocalMethod("expect", arguments));
                }
                String outputExpectation = Templates.callMethodChainStatement("expectedOutput", methods);
                this.statements.add(outputExpectation);
            }
            if ((serializedInput = this.snapshot.getSetupInput()) != null && !serializedInput.isEmpty()) {
                TestGenerator.this.types.registerTypes(new Type[]{RunWith.class, RecordInput.class, IORecorder.class, SetupInput.class});
                TestGenerator.this.fields.add(Templates.fieldDeclaration("public", SetupInput.class.getSimpleName(), "setupInput"));
                ArrayList<String> methods = new ArrayList<String>();
                for (SerializedInput in : serializedInput) {
                    TestGenerator.this.types.registerImport(in.getDeclaringClass());
                    TestGenerator.this.inputClasses.add(in.getDeclaringClass().getTypeName());
                    Computation result = null;
                    if (in.getResult() != null) {
                        result = in.getResult().accept(TestGenerator.this.setup.create(this.locals, TestGenerator.this.types));
                        this.statements.addAll(result.getStatements());
                    }
                    List args = Stream.of(in.getValues()).map(arg -> arg.accept(TestGenerator.this.setup.create(this.locals, TestGenerator.this.types))).collect(Collectors.toList());
                    this.statements.addAll(args.stream().flatMap(arg -> arg.getStatements().stream()).collect(Collectors.toList()));
                    ArrayList<String> arguments = new ArrayList<String>();
                    arguments.add(Templates.classOf(in.getDeclaringClass().getSimpleName()));
                    arguments.add(Templates.stringOf(in.getName()));
                    if (result != null) {
                        arguments.add(result.getValue());
                    } else {
                        arguments.add("null");
                    }
                    arguments.addAll(args.stream().map(arg -> arg.getValue()).collect(Collectors.toList()));
                    methods.add(Templates.callLocalMethod("provide", arguments));
                }
                String string = Templates.callMethodChainStatement("setupInput", methods);
                this.statements.add(string);
            }
            SerializedValueVisitor<Computation> setupCode = TestGenerator.this.setup.create(this.locals, TestGenerator.this.types);
            Computation computation = this.snapshot.getSetupThis().accept(setupCode);
            this.statements.addAll(computation.getStatements());
            List setupArgs = Stream.of(this.snapshot.getSetupArgs()).map(arg -> (Computation)arg.accept(setupCode)).collect(Collectors.toList());
            this.statements.addAll(setupArgs.stream().flatMap(arg -> arg.getStatements().stream()).collect(Collectors.toList()));
            List setupGlobals = Stream.of(this.snapshot.getSetupGlobals()).map(global -> this.assignGlobal(global.getDeclaringClass(), global.getName(), (Computation)global.getValue().accept(setupCode))).collect(Collectors.toList());
            this.statements.addAll(setupGlobals.stream().flatMap(arg -> arg.getStatements().stream()).collect(Collectors.toList()));
            this.base = computation.isStored() ? computation.getValue() : this.assign(this.snapshot.getSetupThis().getType(), computation.getValue());
            this.args = IntStream.range(0, setupArgs.size()).mapToObj(i -> ((Computation)setupArgs.get(i)).isStored() ? ((Computation)setupArgs.get(i)).getValue() : this.assign(this.snapshot.getSetupArgs()[i].getType(), ((Computation)setupArgs.get(i)).getValue())).collect(Collectors.toList());
            return this;
        }

        private Computation assignGlobal(Class<?> clazz, String name, Computation global) {
            ArrayList<String> statements = new ArrayList<String>(global.getStatements());
            String base = TestGenerator.this.types.getSimpleName(clazz);
            statements.add(Templates.assignFieldStatement(base, name, global.getValue()));
            String value = Templates.fieldAccess(base, name);
            return new Computation(value, global.getType(), true, statements);
        }

        public MethodGenerator generateAct() {
            this.statements.add(TestGenerator.BEGIN_ACT);
            Type resultType = this.snapshot.getResultType();
            String methodName = this.snapshot.getMethodName();
            String statement = Templates.callMethod(this.base, methodName, this.args);
            if (resultType != Void.TYPE) {
                this.result = this.assign(resultType, statement, true);
            } else {
                this.execute(statement);
            }
            return this;
        }

        public MethodGenerator generateAssert() {
            TestGenerator.this.types.staticImport(Assert.class, "assertThat");
            this.statements.add(TestGenerator.BEGIN_ASSERT);
            List expectResult = Optional.ofNullable(this.snapshot.getExpectResult()).map(o -> o.accept(TestGenerator.this.matcher.create(this.locals, TestGenerator.this.types))).map(o -> this.createAssertion((Computation)o, this.result)).orElse(Collections.emptyList());
            this.statements.addAll(expectResult);
            List expectThis = Optional.of(this.snapshot.getExpectThis()).filter(o -> !o.equals(this.snapshot.getSetupThis())).map(o -> o.accept(TestGenerator.this.matcher.create(this.locals, TestGenerator.this.types))).map(o -> this.createAssertion((Computation)o, this.base)).orElse(Collections.emptyList());
            this.statements.addAll(expectThis);
            Type[] argumentTypes = this.snapshot.getArgumentTypes();
            SerializedValue[] serializedArgs = this.snapshot.getExpectArgs();
            List expectArgs = IntStream.range(0, argumentTypes.length).filter(i -> !this.isImmutable(argumentTypes[i])).filter(i -> !serializedArgs[i].equals(this.snapshot.getSetupArgs()[i])).mapToObj(i -> this.createAssertion(serializedArgs[i].accept(TestGenerator.this.matcher.create(this.locals, TestGenerator.this.types)), this.args.get(i))).flatMap(statements -> statements.stream()).collect(Collectors.toList());
            this.statements.addAll(expectArgs);
            SerializedField[] serializedGlobals = this.snapshot.getExpectGlobals();
            List expectGlobals = IntStream.range(0, serializedGlobals.length).filter(i -> !this.isImmutable(serializedGlobals[i].getType())).filter(i -> !serializedGlobals[i].equals(this.snapshot.getSetupGlobals()[i])).mapToObj(i -> this.createAssertion(serializedGlobals[i].getValue().accept(TestGenerator.this.matcher.create(this.locals, TestGenerator.this.types)), Templates.fieldAccess(TestGenerator.this.types.getSimpleName(serializedGlobals[i].getDeclaringClass()), serializedGlobals[i].getName()))).flatMap(statements -> statements.stream()).collect(Collectors.toList());
            this.statements.addAll(expectGlobals);
            List<SerializedOutput> serializedOutput = this.snapshot.getExpectOutput();
            if (serializedOutput != null && !serializedOutput.isEmpty()) {
                this.statements.add(Templates.callMethodStatement("expectedOutput", "verify", new String[0]));
            }
            return this;
        }

        private List<String> createAssertion(Computation matcher, String exp) {
            ArrayList<String> statements = new ArrayList<String>();
            statements.addAll(matcher.getStatements());
            statements.add(Templates.callLocalMethodStatement("assertThat", exp, matcher.getValue()));
            return statements;
        }

        public String assign(Type type, String value) {
            return this.assign(type, value, false);
        }

        public String assign(Type type, String value, boolean force) {
            if (this.isImmutable(type) && !force) {
                return value;
            }
            String name = this.locals.fetchName(type);
            this.statements.add(Templates.assignLocalVariableStatement(TestGenerator.this.types.getSimpleName(type), name, value));
            return name;
        }

        public void execute(String value) {
            this.statements.add(Templates.expressionStatement(value));
        }

        private boolean isImmutable(Type type) {
            return TypeManager.isPrimitive(type) || IMMUTABLE_TYPES.contains(type);
        }

        public String generateTest() {
            ST test = new ST(TestGenerator.TEST_TEMPLATE);
            test.add("testName", (Object)this.testName());
            test.add("statements", this.statements);
            return test.render();
        }

        private String testName() {
            String testName = this.snapshot.getMethodName();
            return Character.toUpperCase(testName.charAt(0)) + testName.substring(1) + this.no;
        }
    }
}

