/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.amygdalum.testrecorder.ByteCode;
import net.amygdalum.testrecorder.Snapshot;
import net.amygdalum.testrecorder.SnapshotConfig;
import net.amygdalum.testrecorder.SnapshotExcluded;
import net.amygdalum.testrecorder.SnapshotGenerator;
import net.amygdalum.testrecorder.SnapshotInput;
import net.amygdalum.testrecorder.SnapshotOutput;
import net.amygdalum.testrecorder.visitors.TypeManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SnapshotInstrumentor
implements ClassFileTransformer {
    private static final String Class_name = org.objectweb.asm.Type.getInternalName(Class.class);
    private static final String Object_name = org.objectweb.asm.Type.getInternalName(Object.class);
    private static final String TypeManager_name = org.objectweb.asm.Type.getInternalName(TypeManager.class);
    private static final String SnapShortGenerator_name = org.objectweb.asm.Type.getInternalName(SnapshotGenerator.class);
    private static final String SnapshotGenerator_descriptor = org.objectweb.asm.Type.getDescriptor(SnapshotGenerator.class);
    private static final String SnapshotExcluded_descriptor = org.objectweb.asm.Type.getDescriptor(SnapshotExcluded.class);
    private static final String Snapshot_descriptor = org.objectweb.asm.Type.getDescriptor(Snapshot.class);
    private static final String SnapshotInput_descriptor = org.objectweb.asm.Type.getDescriptor(SnapshotInput.class);
    private static final String SnapshotOutput_descriptor = org.objectweb.asm.Type.getDescriptor(SnapshotOutput.class);
    private static final String Object_getClass_descriptor = ByteCode.methodDescriptor(Object.class, "getClass", new Class[0]);
    private static final String SnapshotGenerator_init_descriptor = ByteCode.constructorDescriptor(SnapshotGenerator.class, Object.class, Class.class);
    private static final String SnapshotGenerator_registerMethod_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "register", String.class, Method.class);
    private static final String SnapshotGenerator_getCurrentGenerator_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "getCurrentGenerator", new Class[0]);
    private static final String SnapshotGenerator_setupVariables_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "setupVariables", String.class, Object[].class);
    private static final String SnapshotGenerator_expectVariablesResult_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "expectVariables", Object.class, Object[].class);
    private static final String SnapshotGenerator_expectVariablesNoResult_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "expectVariables", Object[].class);
    private static final String SnapshotGenerator_throwVariables_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "throwVariables", Throwable.class, Object[].class);
    private static final String SnapshotGenerator_outputVariables_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "outputVariables", Class.class, String.class, Type[].class, Object[].class);
    private static final String SnapshotGenerator_inputVariablesResult_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "inputVariables", Class.class, String.class, Type.class, Object.class, Type[].class, Object[].class);
    private static final String SnapshotGenerator_inputVariablesNoResult_descriptor = ByteCode.methodDescriptor(SnapshotGenerator.class, "inputVariables", Class.class, String.class, Type[].class, Object[].class);
    private static final String TypeManager_getDeclaredMethod_descriptor = ByteCode.methodDescriptor(TypeManager.class, "getDeclaredMethod", Class.class, String.class, Class[].class);
    private static final String CONSTRUCTOR_NAME = "<init>";
    public static final String SNAPSHOT_GENERATOR_FIELD_NAME = "generator";
    private SnapshotConfig config;

    public SnapshotInstrumentor(SnapshotConfig config) {
        this.config = config;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        for (String pkg : this.config.getPackages()) {
            pkg = pkg.replace('.', '/');
            if (className == null || !className.startsWith(pkg)) continue;
            System.out.println("recording snapshots of " + className);
            return this.instrument(new ClassReader(classfileBuffer));
        }
        return null;
    }

    public byte[] instrument(String className) throws IOException {
        return this.instrument(new ClassReader(className));
    }

    public byte[] instrument(ClassReader cr) {
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        this.instrumentFields(classNode);
        this.instrumentConstructors(classNode);
        this.instrumentSnapshotMethods(classNode);
        this.instrumentInputMethods(classNode);
        this.instrumentOutputMethods(classNode);
        ClassWriter out = new ClassWriter(3);
        classNode.accept((ClassVisitor)out);
        return out.toByteArray();
    }

    private void instrumentFields(ClassNode classNode) {
        classNode.fields.add(this.createTestAspectField());
    }

    private void instrumentConstructors(ClassNode classNode) {
        for (MethodNode method : this.getRootConstructors(classNode)) {
            List<InsnNode> rets = this.findReturn(method.instructions);
            for (InsnNode ret : rets) {
                method.instructions.insertBefore((AbstractInsnNode)ret, this.createTestAspectInitializer(classNode));
            }
        }
    }

    private void instrumentSnapshotMethods(ClassNode classNode) {
        for (MethodNode method : this.getSnapshotMethods(classNode)) {
            LabelNode tryLabel = new LabelNode();
            LabelNode catchLabel = new LabelNode();
            LabelNode finallyLabel = new LabelNode();
            method.tryCatchBlocks.add(this.createTryCatchBlock(tryLabel, catchLabel));
            method.instructions.insert(this.createTry(tryLabel, this.setupVariables(classNode, method)));
            List<InsnNode> rets = this.findReturn(method.instructions);
            for (InsnNode ret2 : rets) {
                method.instructions.insert((AbstractInsnNode)ret2, (AbstractInsnNode)new JumpInsnNode(167, finallyLabel));
                method.instructions.remove((AbstractInsnNode)ret2);
            }
            int returnOpcode = rets.stream().map(ret -> ret.getOpcode()).distinct().findFirst().orElse(177);
            method.instructions.add(this.createCatchFinally(catchLabel, this.throwVariables(classNode, method), finallyLabel, this.expectVariables(classNode, method), new InsnNode(returnOpcode)));
        }
    }

    private void instrumentInputMethods(ClassNode classNode) {
        for (MethodNode method : this.getInputMethods(classNode)) {
            List<InsnNode> rets = this.findReturn(method.instructions);
            InsnList notifyInput = this.notifyInput(classNode, method);
            for (InsnNode ret : rets) {
                method.instructions.insertBefore((AbstractInsnNode)ret, notifyInput);
            }
        }
    }

    private void instrumentOutputMethods(ClassNode classNode) {
        for (MethodNode method : this.getOutputMethods(classNode)) {
            method.instructions.insert(this.notifyOutput(classNode, method));
        }
    }

    private FieldNode createTestAspectField() {
        FieldNode fieldNode = new FieldNode(4098, SNAPSHOT_GENERATOR_FIELD_NAME, SnapshotGenerator_descriptor, SnapshotGenerator_descriptor, null);
        fieldNode.visibleAnnotations = new ArrayList();
        fieldNode.visibleAnnotations.add(new AnnotationNode(SnapshotExcluded_descriptor));
        return fieldNode;
    }

    private List<MethodNode> getRootConstructors(ClassNode classNode) {
        return classNode.methods.stream().filter(method -> this.isConstructor((MethodNode)method)).filter(method -> this.isRoot((MethodNode)method, classNode.name)).collect(Collectors.toList());
    }

    private boolean isConstructor(MethodNode method) {
        return method.name.equals(CONSTRUCTOR_NAME);
    }

    private boolean isRoot(MethodNode method, String name) {
        return this.stream(method.instructions.iterator()).filter(insn -> insn.getOpcode() == 183 && insn instanceof MethodInsnNode).map(insn -> (MethodInsnNode)insn).filter(insn -> insn.name.equals(CONSTRUCTOR_NAME)).noneMatch(insn -> insn.owner != null && insn.owner.equals(name));
    }

    private <T> Stream<T> stream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }

    private List<InsnNode> findReturn(InsnList instructions) {
        return this.stream(instructions.iterator()).filter(insn -> insn instanceof InsnNode).map(insn -> (InsnNode)insn).filter(insn -> 172 <= insn.getOpcode() && insn.getOpcode() <= 177).collect(Collectors.toList());
    }

    private InsnList createTestAspectInitializer(ClassNode classNode) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new TypeInsnNode(187, SnapShortGenerator_name));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)org.objectweb.asm.Type.getType(this.config.getClass())));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, SnapShortGenerator_name, CONSTRUCTOR_NAME, SnapshotGenerator_init_descriptor, false));
        insnList.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, SNAPSHOT_GENERATOR_FIELD_NAME, SnapshotGenerator_descriptor));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, SNAPSHOT_GENERATOR_FIELD_NAME, SnapshotGenerator_descriptor));
        for (MethodNode methodNode : this.getSnapshotMethods(classNode)) {
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)this.keySignature(classNode, methodNode)));
            insnList.add(this.pushMethod(classNode, methodNode));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "register", SnapshotGenerator_registerMethod_descriptor, false));
        }
        insnList.add((AbstractInsnNode)new InsnNode(87));
        return insnList;
    }

    private InsnList pushMethod(ClassNode clazz, MethodNode method) {
        org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)method.desc);
        int argCount = argumentTypes.length;
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, Object_name, "getClass", Object_getClass_descriptor, false));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)method.name));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)argCount));
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, Class_name));
        for (int i = 0; i < argCount; ++i) {
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)i));
            insnList.add(ByteCode.pushType(argumentTypes[i]));
            insnList.add((AbstractInsnNode)new InsnNode(83));
        }
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, TypeManager_name, "getDeclaredMethod", TypeManager_getDeclaredMethod_descriptor, false));
        return insnList;
    }

    private List<MethodNode> getSnapshotMethods(ClassNode classNode) {
        return classNode.methods.stream().filter(method -> this.isSnapshotMethod((MethodNode)method)).collect(Collectors.toList());
    }

    private boolean isSnapshotMethod(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        return method.visibleAnnotations.stream().anyMatch(annotation -> annotation.desc.equals(Snapshot_descriptor));
    }

    private List<MethodNode> getInputMethods(ClassNode classNode) {
        return classNode.methods.stream().filter(method -> this.isInputMethod((MethodNode)method)).collect(Collectors.toList());
    }

    private boolean isInputMethod(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        return method.visibleAnnotations.stream().anyMatch(annotation -> annotation.desc.equals(SnapshotInput_descriptor));
    }

    private List<MethodNode> getOutputMethods(ClassNode classNode) {
        return classNode.methods.stream().filter(method -> this.isOutputMethod((MethodNode)method)).collect(Collectors.toList());
    }

    private boolean isOutputMethod(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        return method.visibleAnnotations.stream().anyMatch(annotation -> annotation.desc.equals(SnapshotOutput_descriptor));
    }

    private TryCatchBlockNode createTryCatchBlock(LabelNode tryLabel, LabelNode catchLabel) {
        return new TryCatchBlockNode(tryLabel, catchLabel, catchLabel, null);
    }

    private InsnList createTry(LabelNode tryLabel, InsnList onBegin) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)tryLabel);
        insnList.add(onBegin);
        return insnList;
    }

    private InsnList createCatchFinally(LabelNode catchLabel, InsnList onError, LabelNode finallyLabel, InsnList onSuccess, InsnNode ret) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new JumpInsnNode(167, finallyLabel));
        insnList.add((AbstractInsnNode)catchLabel);
        insnList.add(onError);
        insnList.add((AbstractInsnNode)new InsnNode(191));
        insnList.add((AbstractInsnNode)finallyLabel);
        insnList.add(onSuccess);
        insnList.add((AbstractInsnNode)ret);
        return insnList;
    }

    private InsnList setupVariables(ClassNode classNode, MethodNode methodNode) {
        org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, SNAPSHOT_GENERATOR_FIELD_NAME, SnapshotGenerator_descriptor));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)this.keySignature(classNode, methodNode)));
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "setupVariables", SnapshotGenerator_setupVariables_descriptor, false));
        return insnList;
    }

    private InsnList expectVariables(ClassNode classNode, MethodNode methodNode) {
        org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getReturnType((String)methodNode.desc);
        org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        int newLocal = methodNode.maxLocals;
        if (returnType.getSize() > 0) {
            insnList.add(ByteCode.memorizeLocal(returnType, newLocal));
        }
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, SNAPSHOT_GENERATOR_FIELD_NAME, SnapshotGenerator_descriptor));
        if (returnType.getSize() > 0) {
            insnList.add(ByteCode.recallLocal(newLocal));
        }
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        if (returnType.getSize() > 0) {
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "expectVariables", SnapshotGenerator_expectVariablesResult_descriptor, false));
        } else {
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "expectVariables", SnapshotGenerator_expectVariablesNoResult_descriptor, false));
        }
        return insnList;
    }

    private InsnList throwVariables(ClassNode classNode, MethodNode methodNode) {
        org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, SNAPSHOT_GENERATOR_FIELD_NAME, SnapshotGenerator_descriptor));
        insnList.add((AbstractInsnNode)new InsnNode(95));
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "throwVariables", SnapshotGenerator_throwVariables_descriptor, false));
        return insnList;
    }

    private InsnList notifyInput(ClassNode classNode, MethodNode methodNode) {
        org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getReturnType((String)methodNode.desc);
        org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        int newLocal = methodNode.maxLocals;
        if (returnType.getSize() > 0) {
            insnList.add(ByteCode.memorizeLocal(returnType, newLocal));
        }
        LabelNode skip = new LabelNode();
        LabelNode done = new LabelNode();
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, SnapShortGenerator_name, "getCurrentGenerator", SnapshotGenerator_getCurrentGenerator_descriptor, false));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new JumpInsnNode(198, skip));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)org.objectweb.asm.Type.getObjectType((String)classNode.name)));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)methodNode.name));
        if (returnType.getSize() > 0) {
            insnList.add(ByteCode.pushType(returnType));
            insnList.add(ByteCode.recallLocal(newLocal));
        }
        insnList.add(ByteCode.pushTypes(argumentTypes));
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        if (returnType.getSize() > 0) {
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "inputVariables", SnapshotGenerator_inputVariablesResult_descriptor, false));
        } else {
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "inputVariables", SnapshotGenerator_inputVariablesNoResult_descriptor, false));
        }
        insnList.add((AbstractInsnNode)new JumpInsnNode(167, done));
        insnList.add((AbstractInsnNode)skip);
        insnList.add((AbstractInsnNode)new InsnNode(87));
        insnList.add((AbstractInsnNode)done);
        return insnList;
    }

    private InsnList notifyOutput(ClassNode classNode, MethodNode methodNode) {
        org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        LabelNode skip = new LabelNode();
        LabelNode done = new LabelNode();
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, SnapShortGenerator_name, "getCurrentGenerator", SnapshotGenerator_getCurrentGenerator_descriptor, false));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new JumpInsnNode(198, skip));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)org.objectweb.asm.Type.getObjectType((String)classNode.name)));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)methodNode.name));
        insnList.add(ByteCode.pushTypes(argumentTypes));
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, SnapShortGenerator_name, "outputVariables", SnapshotGenerator_outputVariables_descriptor, false));
        insnList.add((AbstractInsnNode)new JumpInsnNode(167, done));
        insnList.add((AbstractInsnNode)skip);
        insnList.add((AbstractInsnNode)new InsnNode(87));
        insnList.add((AbstractInsnNode)done);
        return insnList;
    }

    private String keySignature(ClassNode classNode, MethodNode methodNode) {
        return classNode.name + ":" + methodNode.name + methodNode.desc;
    }
}

