/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInject;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static String extractMinimalClassnameId(JavaType baseType, JavaType child) {
        String base = baseType.getRawClass().getName();
        int ix = base.lastIndexOf(46);
        String basePackagePrefix = ix < 0 ? "." : base.substring(0, ix + 1);
        String n = child.getRawClass().getName();
        if (n.startsWith(basePackagePrefix)) {
            return n.substring(basePackagePrefix.length() - 1);
        }
        return n;
    }

    public static void merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                Utils.merge(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            ObjectNode node = (ObjectNode)mainNode;
            JsonNode value = updateNode.get(fieldName);
            node.set(fieldName, value);
        }
    }

    public static void visit(JsonNode o, String path, BiConsumer<ObjectNode, String> f) {
        String[] parts = path.split(Pattern.quote("/"));
        String lastPart = parts[parts.length - 1];
        String[] otherParts = Arrays.copyOfRange(parts, 0, parts.length - 1);
        JsonNode p = o;
        for (String name : otherParts) {
            JsonNode child = p.get(name);
            if (child == null) {
                child = ((ObjectNode)p).putObject(name);
            }
            p = child;
        }
        f.accept((ObjectNode)p, lastPart);
    }

    public static String camelCaseToSentenceCase(String propertyName) {
        String s = propertyName.replaceAll("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])", " ");
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static JavaType resolveElementType(JavaType propertyType, BeanProperty prop, ObjectMapper objectMapper) {
        JavaType containedType = propertyType.containedType(0);
        if (containedType.getRawClass() == Object.class) {
            JsonDeserialize jsonDeserialize = (JsonDeserialize)prop.getAnnotation(JsonDeserialize.class);
            if (jsonDeserialize != null) {
                return objectMapper.getTypeFactory().constructType((Type)jsonDeserialize.contentAs());
            }
            log.debug("Use @JsonDeserialize(contentAs=, keyAs=) to specify type of collection elements of {}", (Object)prop);
            return containedType;
        }
        return containedType;
    }

    public static ArrayNode getRequiredArrayNode(ObjectNode objectNode) {
        JsonNode requiredNode = objectNode.get("required");
        if (requiredNode == null) {
            requiredNode = JsonNodeFactory.instance.arrayNode();
            objectNode.set("required", requiredNode);
        }
        return (ArrayNode)requiredNode;
    }

    public static ObjectNode getOptionsNode(ObjectNode objectNode) {
        return Utils.getOrCreateObjectChild(objectNode, "options");
    }

    public static ObjectNode getOrCreateObjectChild(ObjectNode parentObjectNode, String name) {
        JsonNode childNode = parentObjectNode.get(name);
        if (childNode == null) {
            childNode = JsonNodeFactory.instance.objectNode();
            parentObjectNode.set(name, childNode);
        }
        return (ObjectNode)childNode;
    }

    public static String extractTypeName(JavaType type) {
        JsonTypeName annotation = type.getRawClass().getDeclaredAnnotation(JsonTypeName.class);
        return Optional.ofNullable(annotation).flatMap(a -> Optional.of(a.value())).filter(a -> !a.isEmpty()).orElse(type.getRawClass().getSimpleName());
    }

    public static List<Class<?>> extractGroupsFromAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        if (annotationClass.getPackage().getName().startsWith("javax.validation.constraints")) {
            try {
                Class[] groups = (Class[])annotationClass.getMethod("groups", new Class[0]).invoke((Object)annotation, new Object[0]);
                return List.of(groups);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return List.of();
            }
        }
        if (annotation instanceof JsonSchemaInject) {
            JsonSchemaInject _annotation = (JsonSchemaInject)annotation;
            return List.of(_annotation.javaxValidationGroups());
        }
        return List.of();
    }

    public static JavaType getSuperClass(JavaType type) {
        for (JavaType superType : ClassUtil.findSuperTypes((JavaType)type, null, (boolean)false)) {
            if (!superType.getRawClass().isAnnotationPresent(JsonTypeInfo.class)) continue;
            return superType;
        }
        return type.getSuperClass();
    }
}

