/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kjetland.jackson.jsonSchema.JsonSchemaConfig;
import com.kjetland.jackson.jsonSchema.Utils;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class DefinitionsHandler {
    final JsonSchemaConfig config;
    private final Map<JavaType, String> class2Ref = new HashMap<JavaType, String>();
    private final ObjectNode definitionsNode = JsonNodeFactory.instance.objectNode();
    private Deque<Optional<WorkInProgress>> workInProgressStack = new LinkedList<Optional<WorkInProgress>>();
    private Optional<WorkInProgress> workInProgress = Optional.empty();

    public void pushWorkInProgress() {
        this.workInProgressStack.push(this.workInProgress);
        this.workInProgress = Optional.empty();
    }

    public void popworkInProgress() {
        this.workInProgress = this.workInProgressStack.pop();
    }

    public DefinitionInfo getOrCreateDefinition(JavaType type, VisitorSupplier visitorSupplier) throws JsonMappingException {
        String ref = this.class2Ref.get(type);
        if (ref != null) {
            if (this.workInProgress.isEmpty()) {
                return new DefinitionInfo(ref, null);
            }
            if (type != this.workInProgress.get().typeInProgress) {
                throw new IllegalStateException("Wrong type - working on " + this.workInProgress.get().typeInProgress + " - got " + type);
            }
            JsonObjectFormatVisitor visitor = visitorSupplier.get(type, this.workInProgress.get().nodeInProgress);
            return new DefinitionInfo(null, visitor);
        }
        int retryCount = 0;
        String definitionName = this.getDefinitionName(type);
        Object shortRef = definitionName;
        String longRef = "#/definitions/" + definitionName;
        while (this.class2Ref.containsValue(longRef)) {
            shortRef = definitionName + "_" + ++retryCount;
            longRef = "#/definitions/" + definitionName + "_" + retryCount;
        }
        this.class2Ref.put(type, longRef);
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        this.workInProgress = Optional.of(new WorkInProgress(type, node));
        this.definitionsNode.set((String)shortRef, (JsonNode)node);
        JsonObjectFormatVisitor visitor = visitorSupplier.get(type, node);
        this.workInProgress = Optional.empty();
        return new DefinitionInfo(longRef, visitor);
    }

    public ObjectNode getFinalDefinitionsNode() {
        if (this.class2Ref.isEmpty()) {
            return null;
        }
        return this.definitionsNode;
    }

    private String getDefinitionName(JavaType type) {
        String baseName;
        String string = baseName = this.config.useTypeIdForDefinitionName ? type.getRawClass().getTypeName() : Utils.extractTypeName(type);
        if (type.hasGenericTypes()) {
            String containedTypeNames = IntStream.range(0, type.containedTypeCount()).mapToObj(arg_0 -> ((JavaType)type).containedType(arg_0)).map(this::getDefinitionName).collect(Collectors.joining(","));
            return baseName + "(" + containedTypeNames + ")";
        }
        return baseName;
    }

    public DefinitionsHandler(JsonSchemaConfig config) {
        this.config = config;
    }

    record DefinitionInfo(String ref, JsonObjectFormatVisitor jsonObjectFormatVisitor) {
    }

    record WorkInProgress(JavaType typeInProgress, ObjectNode nodeInProgress) {
    }

    @FunctionalInterface
    static interface VisitorSupplier {
        public JsonObjectFormatVisitor get(JavaType var1, ObjectNode var2) throws JsonMappingException;
    }
}

