/*
 * Decompiled with CFR 0.152.
 */
package net.alexandroid.shpref;

import android.support.annotation.NonNull;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import net.alexandroid.shpref.Contextor;

public class MyLog {
    private static String sTag = "MyLog-";
    private static boolean sShowLogs = false;
    private static boolean sIsPackageNameVisible = true;
    private static boolean sIsThreadIdVisible = true;
    private static boolean sIsTimeVisible = false;
    private static boolean sIsRemoveOverride = false;

    public static void showLogs(boolean pShowLogs) {
        sShowLogs = pShowLogs;
    }

    public static void setTag(String pTag) {
        sTag = pTag + " - ";
    }

    public static void setPackageNameVisibility(boolean newValue) {
        sIsPackageNameVisible = newValue;
    }

    public static void setThreadIdVisibility(boolean newValue) {
        sIsThreadIdVisible = newValue;
    }

    public static void setIsTimeVisible(boolean newValue) {
        sIsTimeVisible = newValue;
    }

    public static void setIsRemoveOverride(boolean newValue) {
        sIsRemoveOverride = newValue;
    }

    public static void v(String msg) {
        if (sShowLogs) {
            MyLog.logIt(2, msg);
        }
    }

    public static void d(String msg) {
        if (sShowLogs) {
            MyLog.logIt(3, msg);
        }
    }

    public static void i(String msg) {
        if (sShowLogs) {
            MyLog.logIt(4, msg);
        }
    }

    public static void w(String msg) {
        if (sShowLogs) {
            MyLog.logIt(5, msg);
        }
    }

    public static void e(String msg) {
        if (sShowLogs) {
            MyLog.logIt(6, msg);
        }
    }

    public static void a(String msg) {
        if (sShowLogs) {
            MyLog.logIt(7, msg);
        }
    }

    private static void logIt(int level, String msg) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null && stackTrace.length > 4) {
            StackTraceElement element = stackTrace[4];
            StringBuilder result = new StringBuilder();
            if (sIsTimeVisible) {
                result.append(MyLog.getTime()).append(" - ");
            }
            if (sIsThreadIdVisible) {
                result.append("T:").append((CharSequence)MyLog.getThreadId()).append(" | ");
            }
            StringBuilder simpleClassName = new StringBuilder();
            String fullClassName = element.getClassName();
            if (sIsPackageNameVisible) {
                String packageName = Contextor.getInstance().getContext().getPackageName();
                simpleClassName.append(fullClassName.replace(packageName, ""));
            } else {
                simpleClassName.append(fullClassName.substring(fullClassName.lastIndexOf(46)));
            }
            if (sIsRemoveOverride && simpleClassName.indexOf("$override") != -1) {
                simpleClassName.replace(simpleClassName.indexOf("$override"), simpleClassName.length(), "*");
            }
            while (simpleClassName.length() < (sIsPackageNameVisible ? 35 : 15)) {
                simpleClassName.append(" ");
            }
            result.append((CharSequence)simpleClassName).append(" # ");
            StringBuilder methodName = new StringBuilder(element.getMethodName());
            methodName.append("()");
            while (methodName.length() < 25) {
                methodName.append(" ");
            }
            result.append((CharSequence)methodName).append(" => ");
            result.append(msg);
            Log.println((int)level, (String)sTag, (String)result.toString());
        }
    }

    @NonNull
    private static StringBuilder getThreadId() {
        StringBuilder threadId = new StringBuilder(String.valueOf(Thread.currentThread().getId()));
        while (threadId.length() < 6) {
            threadId.append(" ");
        }
        return threadId;
    }

    private static String getTime() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
        return df.format(Calendar.getInstance().getTime());
    }
}

