/*
 * Decompiled with CFR 0.152.
 */
package net.alexandroid.shpref;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.preference.PreferenceManager;

@SuppressLint(value={"CommitPrefEdits"})
public class ShPref {
    public static final int APPLY = 0;
    public static final int COMMIT = 1;
    private static int sDefaultWriteMode;
    private static SharedPreferences sShPref;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sAppContext;
    private static boolean forceApply;
    private static boolean forceCommit;

    public static void init(Context context, int defaultWriteMode) {
        sAppContext = context;
        sShPref = PreferenceManager.getDefaultSharedPreferences((Context)context);
        sDefaultWriteMode = defaultWriteMode;
    }

    public static void putC(int key, Object value) {
        forceCommit = true;
        ShPref.put(sAppContext.getString(key), value);
    }

    public static void putC(String key, Object value) {
        forceCommit = true;
        ShPref.put(key, value);
    }

    public static void putA(int key, Object value) {
        forceApply = true;
        ShPref.put(sAppContext.getString(key), value);
    }

    public static void putA(String key, Object value) {
        forceApply = true;
        ShPref.put(key, value);
    }

    public static void put(int key, Object value) {
        ShPref.put(sAppContext.getString(key), value);
    }

    public static void put(String key, Object value) {
        SharedPreferences.Editor editor;
        if (value instanceof String) {
            editor = sShPref.edit().putString(key, (String)value);
        } else if (value instanceof Integer) {
            editor = sShPref.edit().putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            editor = sShPref.edit().putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Float) {
            editor = sShPref.edit().putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            editor = sShPref.edit().putLong(key, ((Long)value).longValue());
        } else {
            return;
        }
        if (forceApply || sDefaultWriteMode == 0 && !forceCommit) {
            forceApply = false;
            editor.apply();
        } else {
            forceCommit = false;
            editor.commit();
        }
    }

    public static String getString(int key, String defaultValue) {
        return ShPref.getString(sAppContext.getString(key), defaultValue);
    }

    public static String getString(String key, String defaultValue) {
        try {
            return sShPref.getString(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static int getInt(int key, int defaultValue) {
        return ShPref.getInt(sAppContext.getString(key), defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        try {
            return sShPref.getInt(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(int key, boolean defaultValue) {
        return ShPref.getBoolean(sAppContext.getString(key), defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        try {
            return sShPref.getBoolean(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static float getFloat(int key, float defaultValue) {
        return ShPref.getFloat(sAppContext.getString(key), defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        try {
            return sShPref.getFloat(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static long getLong(int key, long defaultValue) {
        return ShPref.getLong(sAppContext.getString(key), defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        try {
            return sShPref.getLong(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static void removeA(int key) {
        forceApply = true;
        ShPref.remove(sAppContext.getString(key));
    }

    public static void removeC(int key) {
        forceCommit = true;
        ShPref.remove(sAppContext.getString(key));
    }

    public static void removeA(String key) {
        forceApply = true;
        ShPref.remove(key);
    }

    public static void removeC(String key) {
        forceCommit = true;
        ShPref.remove(key);
    }

    public static void remove(int key) {
        ShPref.remove(sAppContext.getString(key));
    }

    public static void remove(String key) {
        SharedPreferences.Editor editor = sShPref.edit().remove(key);
        if (forceApply || sDefaultWriteMode == 0 && !forceCommit) {
            forceApply = false;
            editor.apply();
        } else {
            forceCommit = false;
            editor.commit();
        }
    }
}

