/*
 * Decompiled with CFR 0.152.
 */
package net_alchim31_maven_yuicompressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import net_alchim31_maven_yuicompressor.Aggregation;
import net_alchim31_maven_yuicompressor.MojoSupport;
import net_alchim31_maven_yuicompressor.SourceFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

public class YuiCompressorMojo
extends MojoSupport {
    private String encoding;
    private String suffix;
    private boolean nosuffix;
    private int linebreakpos;
    private boolean nocompress;
    private boolean nomunge;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private boolean force;
    private Aggregation[] aggregations;
    private boolean gzip;
    private boolean statistics;
    private boolean preProcessAggregates;
    private long inSizeTotal_;
    private long outSizeTotal_;

    @Override
    protected String[] getDefaultIncludes() throws Exception {
        return new String[]{"**/*.css", "**/*.js"};
    }

    @Override
    public void beforeProcess() throws Exception {
        if (this.nosuffix) {
            this.suffix = "";
        }
        if (this.preProcessAggregates) {
            this.aggregate();
        }
    }

    @Override
    protected void afterProcess() throws Exception {
        if (this.statistics && this.inSizeTotal_ > 0L) {
            this.getLog().info((CharSequence)String.format("total input (%db) -> output (%db)[%d%%]", this.inSizeTotal_, this.outSizeTotal_, this.outSizeTotal_ * 100L / this.inSizeTotal_));
        }
        if (!this.preProcessAggregates) {
            this.aggregate();
        }
    }

    private void aggregate() throws Exception {
        if (this.aggregations != null) {
            for (Aggregation aggregation : this.aggregations) {
                this.getLog().info((CharSequence)("generate aggregation : " + aggregation.output));
                aggregation.run();
                File gzipped = this.gzipIfRequested(aggregation.output);
                if (!this.statistics) continue;
                if (gzipped != null) {
                    this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", aggregation.output.getName(), aggregation.output.length(), gzipped.getName(), gzipped.length(), this.ratioOfSize(aggregation.output, gzipped)));
                    continue;
                }
                if (aggregation.output.exists()) {
                    this.getLog().info((CharSequence)String.format("%s (%db)", aggregation.output.getName(), aggregation.output.length()));
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("%s not created", aggregation.output.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFile(SourceFile src) throws Exception {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("compress file :" + src.toFile() + " to " + src.toDestFile(this.suffix)));
        }
        File inFile = src.toFile();
        File outFile = src.toDestFile(this.suffix);
        this.getLog().debug((CharSequence)"only compress if input file is younger than existing output file");
        if (!this.force && outFile.exists() && outFile.lastModified() > inFile.lastModified()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("nothing to do, " + outFile + " is younger than original, use 'force' option or clean your target"));
            }
            return;
        }
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        File outFileTmp = new File(outFile.getAbsolutePath() + ".tmp");
        FileUtils.forceDelete((File)outFileTmp);
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(inFile), this.encoding);
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new MojoExecutionException("Cannot create resource output directory: " + outFile.getParentFile());
            }
            this.getLog().debug((CharSequence)"use a temporary outputfile (in case in == out)");
            this.getLog().debug((CharSequence)"start compression");
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTmp), this.encoding);
            if (this.nocompress) {
                this.getLog().info((CharSequence)"No compression is enabled");
                IOUtil.copy((Reader)in, (Writer)out);
            } else if (".js".equalsIgnoreCase(src.getExtension())) {
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, (ErrorReporter)this.jsErrorReporter_);
                compressor.compress((Writer)out, this.linebreakpos, !this.nomunge, this.jswarn, this.preserveAllSemiColons, this.disableOptimizations);
            } else if (".css".equalsIgnoreCase(src.getExtension())) {
                this.compressCss(in, out);
            }
            this.getLog().debug((CharSequence)"end compression");
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Reader)in);
        IOUtil.close((Writer)out);
        FileUtils.forceDelete((File)outFile);
        FileUtils.rename((File)outFileTmp, (File)outFile);
        File gzipped = this.gzipIfRequested(outFile);
        if (this.statistics) {
            this.inSizeTotal_ += inFile.length();
            this.outSizeTotal_ += outFile.length();
            this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", inFile.getName(), inFile.length(), outFile.getName(), outFile.length(), this.ratioOfSize(inFile, outFile)));
            if (gzipped != null) {
                this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", inFile.getName(), inFile.length(), gzipped.getName(), gzipped.length(), this.ratioOfSize(inFile, gzipped)));
            }
        }
    }

    private void compressCss(InputStreamReader in, OutputStreamWriter out) throws IOException {
        try {
            CssCompressor compressor = new CssCompressor((Reader)in);
            compressor.compress((Writer)out, this.linebreakpos);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unexpected characters found in CSS file. Ensure that the CSS file does not contain '$', and try again", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File gzipIfRequested(File file) throws Exception {
        if (!this.gzip || file == null || !file.exists()) {
            return null;
        }
        if (".gz".equalsIgnoreCase(FileUtils.getExtension((String)file.getName()))) {
            return null;
        }
        File gzipped = new File(file.getAbsolutePath() + ".gz");
        this.getLog().debug((CharSequence)String.format("create gzip version : %s", gzipped.getName()));
        GZIPOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(gzipped));
            in = new FileInputStream(file);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return gzipped;
    }

    protected long ratioOfSize(File file100, File fileX) throws Exception {
        long v100 = Math.max(file100.length(), 1L);
        long vX = Math.max(fileX.length(), 1L);
        return vX * 100L / v100;
    }
}

