/*
 * Decompiled with CFR 0.152.
 */
package name.remal.reflection;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import name.remal.SneakyThrow;
import name.remal.UncheckedCast;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainClassUtils {
    private static final String MANIFEST_RESOURCE_NAME = "META-INF/MANIFEST.MF";
    private static final Method findResourcesMethod;

    public static void invokeMainMethod(@NotNull ClassLoader classLoader, String ... args) {
        Class<?> mainClass = MainClassUtils.getMainClass(classLoader);
        if (mainClass == null) {
            throw new IllegalStateException("Main class can't be found for: " + classLoader);
        }
        try {
            Method mainMethod = mainClass.getMethod("main", String[].class);
            mainMethod.setAccessible(true);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            throw SneakyThrow.sneakyThrow(e.getTargetException());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @Nullable
    public static Class<?> getMainClass(@NotNull ClassLoader classLoader) {
        String mainClassName = MainClassUtils.getMainClassName(classLoader);
        if (mainClassName != null) {
            try {
                return classLoader.loadClass(mainClassName);
            }
            catch (ClassNotFoundException e) {
                throw SneakyThrow.sneakyThrow(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getMainClassName(@NotNull ClassLoader classLoader) {
        try {
            Enumeration manifestURLs = (Enumeration)UncheckedCast.uncheckedCast(findResourcesMethod.invoke((Object)classLoader, MANIFEST_RESOURCE_NAME));
            while (true) {
                if (!manifestURLs.hasMoreElements()) {
                    ClassLoader parentClassLoader = classLoader.getParent();
                    if (parentClassLoader == null) return null;
                    if (ClassLoader.getSystemClassLoader() == parentClassLoader) return null;
                    return MainClassUtils.getMainClassName(parentClassLoader);
                }
                URL manifestURL = (URL)manifestURLs.nextElement();
                InputStream inputStream = manifestURL.openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(inputStream);
                    String mainClassName = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                    if (mainClassName == null) continue;
                    String string = mainClassName;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    static {
        try {
            findResourcesMethod = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            findResourcesMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }
}

