/*
 * Decompiled with CFR 0.152.
 */
package name.remal.reflection;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import name.remal.tools.common.internal._relocated.org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedURLClassLoader
extends URLClassLoader {
    @NotNull
    private final LoadingOrderFactory loadingOrderFactory;
    private static final ClassLoader BOOTSTRAP_CLASS_LOADER;

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull URL[] urls, @Nullable ClassLoader parent) {
        super(ExtendedURLClassLoader.uniqueURLs(urls), parent != null ? parent : ExtendedURLClassLoader.getSystemClassLoader());
        this.loadingOrderFactory = loadingOrderFactory;
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull URL[] urls, @Nullable ClassLoader parent) {
        this((String __) -> loadingOrder, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull Iterable<URL> urls, @Nullable ClassLoader parent) {
        this(loadingOrderFactory, ExtendedURLClassLoader.iterableUrlsToArray(urls), parent);
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull Iterable<URL> urls, @Nullable ClassLoader parent) {
        this((String __) -> loadingOrder, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull URL[] urls, @Nullable ClassLoader parent) {
        this(LoadingOrder.PARENT_FIRST, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull Iterable<URL> urls, @Nullable ClassLoader parent) {
        this(LoadingOrder.PARENT_FIRST, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull URL[] urls) {
        this(loadingOrderFactory, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull URL[] urls) {
        this(loadingOrder, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull Iterable<URL> urls) {
        this(loadingOrderFactory, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull Iterable<URL> urls) {
        this(loadingOrder, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull URL[] urls) {
        this(urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull Iterable<URL> urls) {
        this(urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    @Override
    @NotNull
    public final Class<?> loadClass(@NotNull String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Class<?> loadClass(@NotNull String className, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass == null) {
                loadedClass = this.findBootstrapClassOrNull(className);
            }
            if (loadedClass == null) {
                String resourceName = className.replace('.', '/') + ".class";
                LoadingOrder loadingOrder = this.loadingOrderFactory.getLoadingOrder(resourceName);
                if (LoadingOrder.PARENT_FIRST == loadingOrder) {
                    loadedClass = this.findParentClassOrNull(className);
                    if (loadedClass == null) {
                        loadedClass = this.findClassOrNull(className);
                    }
                } else if (LoadingOrder.THIS_FIRST == loadingOrder) {
                    loadedClass = this.findClassOrNull(className);
                    if (loadedClass == null) {
                        loadedClass = this.findParentClassOrNull(className);
                    }
                } else if (LoadingOrder.PARENT_ONLY == loadingOrder) {
                    loadedClass = this.findParentClassOrNull(className);
                } else if (LoadingOrder.THIS_ONLY == loadingOrder) {
                    loadedClass = this.findClassOrNull(className);
                } else {
                    throw new IllegalStateException("Unsupported " + LoadingOrder.class.getSimpleName() + ": " + (Object)((Object)loadingOrder));
                }
            }
            if (loadedClass == null) {
                throw new ClassNotFoundException(className);
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    @Nullable
    protected final Class<?> findBootstrapClassOrNull(@NotNull String className) {
        try {
            return BOOTSTRAP_CLASS_LOADER.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    protected final Class<?> findClassOrNull(@NotNull String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    protected final Class<?> findParentClassOrNull(@NotNull String className) {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            return null;
        }
        try {
            return parent.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public URL getResource(@NotNull String resourceName) {
        URL result;
        LoadingOrder loadingOrder = this.loadingOrderFactory.getLoadingOrder(resourceName);
        if (LoadingOrder.PARENT_FIRST == loadingOrder) {
            result = this.getResourceFromParent(resourceName);
            if (result == null) {
                result = this.findResource(resourceName);
            }
        } else if (LoadingOrder.THIS_FIRST == loadingOrder) {
            result = this.findResource(resourceName);
            if (result == null) {
                result = this.getResourceFromParent(resourceName);
            }
        } else if (LoadingOrder.PARENT_ONLY == loadingOrder) {
            result = this.getResourceFromParent(resourceName);
        } else if (LoadingOrder.THIS_ONLY == loadingOrder) {
            result = this.findResource(resourceName);
        } else {
            throw new IllegalStateException("Unsupported " + LoadingOrder.class.getSimpleName() + ": " + (Object)((Object)loadingOrder));
        }
        return result;
    }

    @Nullable
    private URL getResourceFromParent(@NotNull String resourceName) {
        ClassLoader parentClassLoader = this.getParent();
        if (parentClassLoader != null) {
            return parentClassLoader.getResource(resourceName);
        }
        return ExtendedURLClassLoader.getSystemResource(resourceName);
    }

    @Override
    @NotNull
    public Enumeration<URL> getResources(@NotNull String resourceName) throws IOException {
        LoadingOrder loadingOrder = this.loadingOrderFactory.getLoadingOrder(resourceName);
        if (LoadingOrder.PARENT_FIRST == loadingOrder) {
            return new CompoundEnumeration<URL>(new Enumeration[]{this.getResourcesFromParent(resourceName), this.findResources(resourceName)});
        }
        if (LoadingOrder.THIS_FIRST == loadingOrder) {
            return new CompoundEnumeration<URL>(new Enumeration[]{this.findResources(resourceName), this.getResourcesFromParent(resourceName)});
        }
        if (LoadingOrder.PARENT_ONLY == loadingOrder) {
            return this.getResourcesFromParent(resourceName);
        }
        if (LoadingOrder.THIS_ONLY == loadingOrder) {
            return this.findResources(resourceName);
        }
        throw new IllegalStateException("Unsupported " + LoadingOrder.class.getSimpleName() + ": " + (Object)((Object)loadingOrder));
    }

    @NotNull
    private Enumeration<URL> getResourcesFromParent(@NotNull String resourceName) throws IOException {
        ClassLoader parentClassLoader = this.getParent();
        if (parentClassLoader != null) {
            return parentClassLoader.getResources(resourceName);
        }
        return ExtendedURLClassLoader.getSystemResources(resourceName);
    }

    @Override
    public synchronized void addURL(@NotNull URL url) {
        if (!ArrayUtils.contains(this.getURLs(), url)) {
            super.addURL(url);
        }
    }

    @NotNull
    private static URL[] uniqueURLs(@NotNull URL[] urls) {
        return (URL[])Stream.of(urls).distinct().toArray(URL[]::new);
    }

    @NotNull
    private static URL[] iterableUrlsToArray(@NotNull Iterable<URL> urls) {
        if (urls instanceof List) {
            return ((List)urls).toArray(new URL[0]);
        }
        ArrayList<URL> list = new ArrayList<URL>();
        for (URL url : urls) {
            list.add(url);
        }
        return list.toArray(new URL[0]);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        BOOTSTRAP_CLASS_LOADER = new BootstrapClassLoader();
    }

    private static final class CompoundEnumeration<E>
    implements Enumeration<E> {
        private int index = 0;
        @NotNull
        private final Enumeration<E>[] enums;

        @SafeVarargs
        private CompoundEnumeration(Enumeration<E> ... enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }

    private static final class BootstrapClassLoader
    extends ClassLoader {
        private BootstrapClassLoader() {
            super(null);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    @FunctionalInterface
    public static interface LoadingOrderFactory {
        @NotNull
        public LoadingOrder getLoadingOrder(@NotNull String var1);
    }

    public static enum LoadingOrder {
        PARENT_FIRST,
        THIS_FIRST,
        PARENT_ONLY,
        THIS_ONLY;

    }
}

