/*
 * Decompiled with CFR 0.152.
 */
package name.remal.proxy;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import name.remal.proxy.MethodHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeInvocationHandler
implements InvocationHandler {
    private static final boolean areDefaultMethodsSupported = CompositeInvocationHandler.areDefaultMethodsSupported();
    private final List<@NotNull MethodHandler> methodHandlers = new ArrayList<MethodHandler>();
    @NotNull
    public static final MethodHandler.CanHandle EQUALS_CAN_HANDLE = method -> method.getParameterCount() == 1 && "equals".equals(method.getName());
    @NotNull
    public static final EqualsHandler OBJECT_EQUALS_HANDLER = (proxy, other) -> proxy == other;
    @NotNull
    public static final MethodHandler.CanHandle HASH_CODE_CAN_HANDLE = method -> method.getParameterCount() == 0 && "hashCode".equals(method.getName());
    @NotNull
    public static final HashCodeHandler OBJECT_HASH_CODE_HANDLER = System::identityHashCode;
    @NotNull
    public static final MethodHandler.CanHandle TO_STRING_CAN_HANDLE = method -> method.getParameterCount() == 0 && "toString".equals(method.getName());
    @NotNull
    public static final ToStringHandler OBJECT_TO_STRING_HANDLER = proxy -> proxy.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(proxy));

    private static boolean areDefaultMethodsSupported() {
        try {
            Method.class.getDeclaredMethod("isDefault", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) throws Throwable {
        for (MethodHandler methodHandler : this.methodHandlers) {
            if (!methodHandler.canHandle(method)) continue;
            return methodHandler.handle(proxy, method, args);
        }
        if (areDefaultMethodsSupported && method.isDefault()) {
            MethodHandle methodHandle = MethodHandles.lookup().in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy);
            if (args == null) {
                return methodHandle.invoke();
            }
            return methodHandle.invoke(args);
        }
        if (EQUALS_CAN_HANDLE.canHandle(method)) {
            return OBJECT_EQUALS_HANDLER.handle(proxy, Objects.requireNonNull(args)[0]);
        }
        if (HASH_CODE_CAN_HANDLE.canHandle(method)) {
            return OBJECT_HASH_CODE_HANDLER.handle(proxy);
        }
        if (TO_STRING_CAN_HANDLE.canHandle(method)) {
            return OBJECT_TO_STRING_HANDLER.handle(proxy);
        }
        throw new UnsupportedOperationException(method.toString());
    }

    @NotNull
    public CompositeInvocationHandler prependMethodHandler(@NotNull MethodHandler methodHandler) {
        this.methodHandlers.add(0, methodHandler);
        return this;
    }

    @NotNull
    public CompositeInvocationHandler prependMethodHandler(@NotNull MethodHandler.CanHandle canHandle, @NotNull MethodHandler.Handler handler) {
        return this.prependMethodHandler(MethodHandler.of(canHandle, handler));
    }

    @NotNull
    public CompositeInvocationHandler prependConstMethodHandler(@NotNull MethodHandler.CanHandle canHandle, @Nullable Object predefinedReturnValue) {
        return this.prependMethodHandler(canHandle, (proxy, method, args) -> predefinedReturnValue);
    }

    @NotNull
    public CompositeInvocationHandler appendMethodHandler(@NotNull MethodHandler methodHandler) {
        this.methodHandlers.add(methodHandler);
        return this;
    }

    @NotNull
    public CompositeInvocationHandler appendMethodHandler(@NotNull MethodHandler.CanHandle canHandle, @NotNull MethodHandler.Handler handler) {
        return this.appendMethodHandler(MethodHandler.of(canHandle, handler));
    }

    @NotNull
    public CompositeInvocationHandler appendConstMethodHandler(@NotNull MethodHandler.CanHandle canHandle, @Nullable Object predefinedReturnValue) {
        return this.appendMethodHandler(canHandle, (proxy, method, args) -> predefinedReturnValue);
    }

    @NotNull
    public CompositeInvocationHandler prependObjectEqualsHandler() {
        return this.prependMethodHandler(EQUALS_CAN_HANDLE, (proxy, method, args) -> OBJECT_EQUALS_HANDLER.handle(proxy, Objects.requireNonNull(args)[0]));
    }

    @NotNull
    public CompositeInvocationHandler appendObjectEqualsHandler() {
        return this.appendMethodHandler(EQUALS_CAN_HANDLE, (proxy, method, args) -> OBJECT_EQUALS_HANDLER.handle(proxy, Objects.requireNonNull(args)[0]));
    }

    @NotNull
    private static MethodHandler.Handler wrap(@NotNull EqualsHandler handler) {
        return (proxy, method, args) -> {
            Object other = Objects.requireNonNull(args)[0];
            if (other == null) {
                return Boolean.FALSE;
            }
            if (proxy == other) {
                return Boolean.TRUE;
            }
            return handler.handle(proxy, other);
        };
    }

    @NotNull
    public CompositeInvocationHandler prependEqualsHandler(@NotNull EqualsHandler handler) {
        return this.prependMethodHandler(EQUALS_CAN_HANDLE, CompositeInvocationHandler.wrap(handler));
    }

    @NotNull
    public CompositeInvocationHandler appendEqualsHandler(@NotNull EqualsHandler handler) {
        return this.appendMethodHandler(EQUALS_CAN_HANDLE, CompositeInvocationHandler.wrap(handler));
    }

    @NotNull
    public CompositeInvocationHandler prependObjectHashCodeHandler() {
        return this.prependHashCodeHandler(OBJECT_HASH_CODE_HANDLER);
    }

    @NotNull
    public CompositeInvocationHandler appendObjectHashCodeHandler() {
        return this.appendHashCodeHandler(OBJECT_HASH_CODE_HANDLER);
    }

    @NotNull
    public CompositeInvocationHandler prependHashCodeHandler(@NotNull HashCodeHandler handler) {
        return this.prependMethodHandler(HASH_CODE_CAN_HANDLE, (proxy, method, args) -> handler.handle(proxy));
    }

    @NotNull
    public CompositeInvocationHandler prependHashCodeHandler(int predefinedReturnValue) {
        return this.prependHashCodeHandler(__ -> predefinedReturnValue);
    }

    @NotNull
    public CompositeInvocationHandler appendHashCodeHandler(@NotNull HashCodeHandler handler) {
        return this.appendMethodHandler(HASH_CODE_CAN_HANDLE, (proxy, method, args) -> handler.handle(proxy));
    }

    @NotNull
    public CompositeInvocationHandler appendHashCodeHandler(int predefinedReturnValue) {
        return this.appendHashCodeHandler(__ -> predefinedReturnValue);
    }

    @NotNull
    public CompositeInvocationHandler prependObjectToStringHandler() {
        return this.prependToStringHandler(OBJECT_TO_STRING_HANDLER);
    }

    @NotNull
    public CompositeInvocationHandler appendObjectToStringHandler() {
        return this.appendToStringHandler(OBJECT_TO_STRING_HANDLER);
    }

    @NotNull
    public CompositeInvocationHandler prependToStringHandler(@NotNull ToStringHandler handler) {
        return this.prependMethodHandler(TO_STRING_CAN_HANDLE, (proxy, method, args) -> handler.handle(proxy));
    }

    @NotNull
    public CompositeInvocationHandler prependToStringHandler(@NotNull String predefinedReturnValue) {
        return this.prependToStringHandler((Object __) -> predefinedReturnValue);
    }

    @NotNull
    public CompositeInvocationHandler appendToStringHandler(@NotNull ToStringHandler handler) {
        return this.appendMethodHandler(TO_STRING_CAN_HANDLE, (proxy, method, args) -> handler.handle(proxy));
    }

    @NotNull
    public CompositeInvocationHandler appendToStringHandler(@NotNull String predefinedReturnValue) {
        return this.appendToStringHandler((Object __) -> predefinedReturnValue);
    }

    @FunctionalInterface
    public static interface ToStringHandler {
        @NotNull
        public String handle(@NotNull Object var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface HashCodeHandler {
        public int handle(@NotNull Object var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface EqualsHandler {
        public boolean handle(@NotNull Object var1, @Nullable Object var2) throws Throwable;
    }
}

