/*
 * Decompiled with CFR 0.152.
 */
package name.remal.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import name.remal.SneakyThrow;
import name.remal.lambda.Function1;
import org.jetbrains.annotations.NotNull;

public class LockingFileOperations {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final ConcurrentMap<File, Object> FILE_LOCKS = new ConcurrentHashMap<File, Object>();
    private static final long MILLI_NANOS = ChronoUnit.MILLIS.getDuration().toNanos();
    private static final long SECOND_MILLIS = ChronoUnit.SECONDS.getDuration().toMillis();

    @NotNull
    public static byte[] lockAndReadBytes(@NotNull File file, @NotNull Duration lockAcquiringTimeout) {
        try {
            File absoluteFile = file.getAbsoluteFile();
            return LockingFileOperations.forLockedFileChannel(absoluteFile, "r", lockAcquiringTimeout, channel -> {
                long size = channel.size();
                if (0x7FFFFFF7L < size) {
                    throw new IOException(String.format("%s: File can't be read as bytes array because it's length is %d bytes, that's more than manimum java array length - %d", absoluteFile.getPath(), size, 0x7FFFFFF7));
                }
                byte[] bytes = new byte[(int)size];
                channel.read(ByteBuffer.wrap(bytes));
                return bytes;
            });
        }
        catch (Throwable throwable) {
            throw SneakyThrow.sneakyThrow(throwable);
        }
    }

    public static void lockAndWriteBytes(@NotNull File file, @NotNull Duration lockAcquiringTimeout, @NotNull byte[] bytes) {
        try {
            LockingFileOperations.forLockedFileChannel(file, "rw", lockAcquiringTimeout, channel -> {
                channel.write(ByteBuffer.wrap(bytes));
                return null;
            });
        }
        catch (Throwable throwable) {
            throw SneakyThrow.sneakyThrow(throwable);
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
    public static <R> R forLockedFileChannel(@NotNull File file, @NotNull String mode, @NotNull Duration lockAcquiringTimeout, @NotNull @NotNull Function1<R, @NotNull FileChannel> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void lockAndDelete(@NotNull File file, @NotNull Duration lockAcquiringTimeout) {
        try {
            file = file.getAbsoluteFile();
            if (file.isFile()) {
                long timeoutNanos = lockAcquiringTimeout.toNanos();
                long sleepMillis = LockingFileOperations.getSleepMillis(timeoutNanos);
                long startNanos = System.nanoTime();
                while (true) {
                    if (file.delete()) {
                        return;
                    }
                    if (System.nanoTime() - startNanos >= timeoutNanos) break;
                    Thread.sleep(sleepMillis);
                }
                throw new IOException(String.format("%s: File can't be deleted for %d nanoseconds", file.getPath(), timeoutNanos));
            }
            if (file.isDirectory()) {
                throw new IllegalArgumentException("File " + file + " is a directory");
            }
        }
        catch (Throwable throwable) {
            throw SneakyThrow.sneakyThrow(throwable);
        }
    }

    private static long getSleepMillis(long timeoutNanos) {
        if (timeoutNanos < MILLI_NANOS) {
            return 1L;
        }
        return Math.min(SECOND_MILLIS, timeoutNanos / MILLI_NANOS / 100L);
    }

    private static /* synthetic */ Object lambda$forLockedFileChannel$2(File it) {
        return it;
    }
}

