/*
 * Decompiled with CFR 0.152.
 */
package name.remal.collections;

import java.util.Map;
import name.remal.collections.EntryAddedHandler;
import name.remal.collections.EntryRemovedHandler;
import name.remal.collections.HandlerRegistration;
import name.remal.collections.MapChangedHandler;
import org.jetbrains.annotations.NotNull;

public interface ObservableMap<K, V>
extends Map<K, V> {
    @NotNull
    public HandlerRegistration registerEntryAddedHandler(@NotNull EntryAddedHandler<K, V> var1);

    @NotNull
    public HandlerRegistration registerEntryRemovedHandler(@NotNull EntryRemovedHandler<K, V> var1);

    @NotNull
    default public HandlerRegistration registerMapChangedHandler(@NotNull MapChangedHandler handler) {
        HandlerRegistration entryAddedHandlerRegistration = this.registerEntryAddedHandler((key, value) -> handler.onMapChanged());
        HandlerRegistration entryRemovedHandlerRegistration = this.registerEntryRemovedHandler((key, value) -> handler.onMapChanged());
        return () -> {
            entryAddedHandlerRegistration.deregister();
            entryRemovedHandlerRegistration.deregister();
        };
    }
}

