/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import name.remal.annotation.bytecode.BytecodeAnnotationAnnotationValue;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.NotNull;

class ExpandingElement {
    @NotNull
    final BytecodeAnnotationAnnotationValue annotationValue;
    @NotNull
    final List<BytecodeAnnotationAnnotationValue> attributes;

    ExpandingElement(@NotNull BytecodeAnnotationAnnotationValue annotationValue) {
        this.annotationValue = annotationValue;
        this.attributes = new ArrayList<BytecodeAnnotationAnnotationValue>();
    }

    ExpandingElement(@NotNull ExpandingElement parent, @NotNull BytecodeAnnotationAnnotationValue annotationValue) {
        this(annotationValue);
        this.attributes.addAll(parent.attributes);
    }

    void applyAttributes(@NotNull BytecodeAnnotationAnnotationValue annotationValue) {
        if (this.attributes.isEmpty()) {
            return;
        }
        String className = annotationValue.getClassName();
        Map<String, BytecodeAnnotationValue> fields = annotationValue.getFields();
        for (int i = this.attributes.size() - 1; i >= 0; --i) {
            BytecodeAnnotationAnnotationValue attribute = this.attributes.get(i);
            if (!attribute.getClassName().equals(className)) continue;
            attribute.getFields().forEach(fields::put);
        }
    }

    @NotNull
    public String toString() {
        return ExpandingElement.class.getSimpleName() + '{' + "annotationValue=" + this.annotationValue + ", attributes=" + this.attributes + '}';
    }
}

