/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.remal.SneakyThrow;
import name.remal.annotation.AnnotationAttributeAlias;
import name.remal.annotation.bytecode.BytecodeAnnotationAnnotationValue;
import name.remal.annotation.bytecode.BytecodeAnnotationAnnotationsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationBooleanValue;
import name.remal.annotation.bytecode.BytecodeAnnotationBooleansArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationByteValue;
import name.remal.annotation.bytecode.BytecodeAnnotationBytesArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationCharValue;
import name.remal.annotation.bytecode.BytecodeAnnotationCharsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationClassValue;
import name.remal.annotation.bytecode.BytecodeAnnotationClassesArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationDoubleValue;
import name.remal.annotation.bytecode.BytecodeAnnotationDoublesArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationEnumValue;
import name.remal.annotation.bytecode.BytecodeAnnotationEnumsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationFloatValue;
import name.remal.annotation.bytecode.BytecodeAnnotationFloatsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationIntValue;
import name.remal.annotation.bytecode.BytecodeAnnotationIntsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationLongValue;
import name.remal.annotation.bytecode.BytecodeAnnotationLongsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationShortValue;
import name.remal.annotation.bytecode.BytecodeAnnotationShortsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationStringValue;
import name.remal.annotation.bytecode.BytecodeAnnotationStringsArrayValue;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import name.remal.annotation.bytecode.BytecodeAnnotationsInfo;
import name.remal.annotation.bytecode.BytecodeRetriever;
import name.remal.annotation.bytecode.ExpandingElement;
import name.remal.gradle_plugins.api.RelocatePackages;
import name.remal.reflection.HierarchyUtils;
import name.remal.tools.common.internal._relocated.me.nallar.whocalled.WhoCalled;
import name.remal.tools.common.internal._relocated.org.objectweb.asm.ClassReader;
import name.remal.tools.common.internal._relocated.org.objectweb.asm.Type;
import name.remal.tools.common.internal._relocated.org.objectweb.asm.tree.AnnotationNode;
import name.remal.tools.common.internal._relocated.org.objectweb.asm.tree.ClassNode;
import name.remal.tools.common.internal._relocated.org.objectweb.asm.tree.FieldNode;
import name.remal.tools.common.internal._relocated.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RelocatePackages(value={"org.objectweb.asm"})
public class BytecodeAnnotationsScanner {
    @NotNull
    private final BytecodeRetriever bytecodeRetriever;
    private static final ClassNode NULL_CLASS_NODE = new ClassNode();
    private final ConcurrentMap<String, ClassNode> classNodesCache = new ConcurrentHashMap<String, ClassNode>();
    private static final Set<String> CORE_CLASS_NAMES = Stream.of(Object.class, Enum.class, Annotation.class, Comparable.class, Cloneable.class, Serializable.class, Externalizable.class, Closeable.class).flatMap(clazz -> HierarchyUtils.getHierarchy(clazz).stream()).map(Class::getName).collect(Collectors.toSet());
    @NotNull
    private final ConcurrentMap<String, BytecodeAnnotationsInfo> bytecodeAnnotationsInfosCache = new ConcurrentHashMap<String, BytecodeAnnotationsInfo>();
    private static final String ANNOTATION_ATTRIBUTE_ALIAS_DESCR = Type.getDescriptor(AnnotationAttributeAlias.class);

    public BytecodeAnnotationsScanner(@NotNull BytecodeRetriever bytecodeRetriever) {
        CORE_CLASS_NAMES.forEach(className -> this.bytecodeAnnotationsInfosCache.put((String)className, new BytecodeAnnotationsInfo((String)className, true)));
        this.bytecodeRetriever = bytecodeRetriever;
    }

    public BytecodeAnnotationsScanner(@NotNull ClassLoader classLoader) {
        this((String className) -> {
            String resourceName = className.replace('.', '/') + ".class";
            try (InputStream inputStream = classLoader.getResourceAsStream(resourceName);){
                byte[] byArray = inputStream != null ? BytecodeAnnotationsScanner.toByteArray(inputStream) : null;
                return byArray;
            }
        });
    }

    public BytecodeAnnotationsScanner() {
        this(WhoCalled.$.getCallingClass().getClassLoader());
    }

    @NotNull
    public @NotNull List<@NotNull BytecodeAnnotationAnnotationValue> getMetaAnnotations(@NotNull String className, @NotNull String annotationClassName) {
        Collection<BytecodeAnnotationsInfo> infos = this.isAnnotationInherited(annotationClassName) ? this.getAllInfos(className) : Collections.singletonList(this.getBytecodeAnnotationsInfo(className));
        return infos.stream().flatMap(info -> info.annotationValues.stream()).filter(annotationValue -> annotationValue.getClassName().equals(annotationClassName)).distinct().collect(Collectors.toList());
    }

    @NotNull
    public @NotNull List<@NotNull BytecodeAnnotationAnnotationValue> getMetaAnnotations(@NotNull Class<?> clazz, @NotNull Class<? extends Annotation> annotationClass) {
        return this.getMetaAnnotations(clazz.getName(), annotationClass.getName());
    }

    @Nullable
    public BytecodeAnnotationAnnotationValue getMetaAnnotation(@NotNull String className, @NotNull String annotationClassName) {
        List<BytecodeAnnotationAnnotationValue> annotationValues = this.getMetaAnnotations(className, annotationClassName);
        return !annotationValues.isEmpty() ? annotationValues.get(0) : null;
    }

    @Nullable
    public BytecodeAnnotationAnnotationValue getMetaAnnotation(@NotNull Class<?> clazz, @NotNull Class<? extends Annotation> annotationClass) {
        return this.getMetaAnnotation(clazz.getName(), annotationClass.getName());
    }

    @Nullable
    private ClassNode getClassNode(@NotNull String className) {
        ClassNode cached = this.classNodesCache.computeIfAbsent(className, curClassName -> {
            try {
                byte[] bytecode = this.bytecodeRetriever.retrieve(className);
                if (bytecode == null) {
                    return NULL_CLASS_NODE;
                }
                ClassNode classNode = new ClassNode();
                new ClassReader(bytecode).accept(classNode, 7);
                return classNode;
            }
            catch (Exception e) {
                throw SneakyThrow.sneakyThrow(e);
            }
        });
        return cached != NULL_CLASS_NODE ? cached : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private BytecodeAnnotationsInfo getBytecodeAnnotationsInfo(@NotNull String className) {
        BytecodeAnnotationsInfo result = this.bytecodeAnnotationsInfosCache.computeIfAbsent(className, BytecodeAnnotationsInfo::new);
        if (!result.isInitialized) {
            BytecodeAnnotationsInfo bytecodeAnnotationsInfo = result;
            synchronized (bytecodeAnnotationsInfo) {
                if (!result.isInitialized) {
                    ClassNode classNode = this.getClassNode(className);
                    if (classNode == null) {
                        throw new IllegalStateException("Bytecode can't be loaded: " + className);
                    }
                    if ((classNode.access & 0x2000) != 0 && BytecodeAnnotationsScanner.isLangCoreClass(className)) {
                        result.isInitialized = true;
                        return result;
                    }
                    LinkedHashSet<String> parentClassNames = new LinkedHashSet<String>();
                    if (classNode.superName != null) {
                        parentClassNames.add(classNode.superName.replace('/', '.'));
                    }
                    if (classNode.interfaces != null) {
                        classNode.interfaces.forEach(internalClassName -> parentClassNames.add(internalClassName.replace('/', '.')));
                    }
                    parentClassNames.forEach(parentClassName -> {
                        BytecodeAnnotationsInfo info = this.getBytecodeAnnotationsInfo((String)parentClassName);
                        if (info.isInitialized) {
                            result.parents.add(info);
                        }
                    });
                    this.collectAnnotations(result.annotationValues, classNode.visibleAnnotations, classNode.invisibleAnnotations);
                    if (classNode.fields != null) {
                        classNode.fields.forEach(fieldNode -> {
                            LinkedHashSet<BytecodeAnnotationAnnotationValue> annotations = new LinkedHashSet<BytecodeAnnotationAnnotationValue>();
                            this.collectAnnotations(annotations, fieldNode.visibleAnnotations, fieldNode.invisibleAnnotations);
                            result.fieldsAnnotations.put(BytecodeAnnotationsScanner.computeKey(fieldNode), annotations);
                        });
                    }
                    if (classNode.methods != null) {
                        classNode.methods.forEach(methodNode -> {
                            LinkedHashSet<BytecodeAnnotationAnnotationValue> annotations = new LinkedHashSet<BytecodeAnnotationAnnotationValue>();
                            this.collectAnnotations(annotations, methodNode.visibleAnnotations, methodNode.invisibleAnnotations);
                            result.methodsAnnotations.put(BytecodeAnnotationsScanner.computeKey(methodNode), annotations);
                        });
                    }
                    result.isInitialized = true;
                }
            }
        }
        return result;
    }

    @SafeVarargs
    private final void collectAnnotations(@NotNull Collection<BytecodeAnnotationAnnotationValue> container, List<AnnotationNode> ... annotationNodesArray) {
        if (annotationNodesArray == null) {
            return;
        }
        for (List<AnnotationNode> annotationNodes : annotationNodesArray) {
            if (annotationNodes == null) continue;
            for (AnnotationNode annotationNode : annotationNodes) {
                ExpandingElement expandingElement;
                if (annotationNode == null) continue;
                LinkedHashSet<BytecodeAnnotationAnnotationValue> annotationValues = new LinkedHashSet<BytecodeAnnotationAnnotationValue>();
                LinkedList<ExpandingElement> queue = new LinkedList<ExpandingElement>();
                queue.add(new ExpandingElement(this.toAnnotationValue(annotationNode)));
                while ((expandingElement = (ExpandingElement)queue.poll()) != null) {
                    ClassNode annotationClassNode;
                    BytecodeAnnotationValue value;
                    BytecodeAnnotationAnnotationValue annotationValue = expandingElement.annotationValue;
                    expandingElement.applyAttributes(annotationValue);
                    if (!annotationValues.add(annotationValue)) continue;
                    if (annotationValue.getFields().size() == 1 && (value = annotationValue.getField("value")) != null && value.isAnnotationsArray()) {
                        BytecodeAnnotationAnnotationValue[] items = value.asAnnotationsArray().getValue();
                        for (int i = items.length - 1; i >= 0; --i) {
                            BytecodeAnnotationAnnotationValue item = items[i];
                            expandingElement.applyAttributes(item);
                            queue.add(new ExpandingElement(expandingElement, item));
                        }
                    }
                    if (BytecodeAnnotationsScanner.isLangCoreClass(annotationValue.getClassName()) || (annotationClassNode = this.getClassNode(annotationValue.getClassName())) == null) continue;
                    Stream.of(annotationClassNode.visibleAnnotations, annotationClassNode.invisibleAnnotations).filter(Objects::nonNull).flatMap(Collection::stream).filter(node -> !BytecodeAnnotationsScanner.isLangCoreClass(node.desc)).map(this::toAnnotationValue).collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(nextAnnotationValue -> {
                        ExpandingElement nextExpandingElement = new ExpandingElement(expandingElement, (BytecodeAnnotationAnnotationValue)nextAnnotationValue);
                        if (annotationClassNode.methods == null) {
                            return;
                        }
                        annotationClassNode.methods.forEach(methodNode -> {
                            if (!methodNode.desc.startsWith("()")) {
                                return;
                            }
                            BytecodeAnnotationValue fieldValue = annotationValue.getField(methodNode.name);
                            if (fieldValue == null) {
                                return;
                            }
                            Stream.of(methodNode.visibleAnnotations, methodNode.invisibleAnnotations).filter(Objects::nonNull).flatMap(Collection::stream).filter(node -> ANNOTATION_ATTRIBUTE_ALIAS_DESCR.equals(node.desc)).map(this::toAnnotationValue).forEach(methodAnnotationValue -> {
                                String annotationClassName = Optional.ofNullable(methodAnnotationValue.getField("annotationClass")).map(BytecodeAnnotationValue::asClass).map(BytecodeAnnotationClassValue::getClassName).orElse(null);
                                if (annotationClassName == null) {
                                    return;
                                }
                                BytecodeAnnotationAnnotationValue attr = new BytecodeAnnotationAnnotationValue(annotationClassName);
                                String attributeName = Optional.ofNullable(methodAnnotationValue.getField("attributeName")).map(BytecodeAnnotationValue::asString).map(BytecodeAnnotationStringValue::getValue).orElse(null);
                                if (attributeName == null) {
                                    return;
                                }
                                attr.setField(attributeName, fieldValue);
                                nextExpandingElement.attributes.add(attr);
                            });
                        });
                        queue.add(nextExpandingElement);
                    });
                }
                if (annotationValues.size() == 1) {
                    container.add((BytecodeAnnotationAnnotationValue)annotationValues.iterator().next());
                    continue;
                }
                ArrayList list = new ArrayList(annotationValues);
                Collections.reverse(list);
                container.addAll(list);
            }
        }
    }

    private boolean isAnnotationInherited(@NotNull String annotationClassName) {
        BytecodeAnnotationsInfo info = this.getBytecodeAnnotationsInfo(annotationClassName);
        for (BytecodeAnnotationAnnotationValue annotationValue : info.annotationValues) {
            if (!Inherited.class.getName().equals(annotationValue.getClassName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Collection<BytecodeAnnotationsInfo> getAllInfos(@NotNull String rootClassName) {
        BytecodeAnnotationsInfo info;
        LinkedHashMap<String, BytecodeAnnotationsInfo> result = new LinkedHashMap<String, BytecodeAnnotationsInfo>();
        LinkedList<BytecodeAnnotationsInfo> queue = new LinkedList<BytecodeAnnotationsInfo>();
        queue.add(this.getBytecodeAnnotationsInfo(rootClassName));
        while ((info = (BytecodeAnnotationsInfo)queue.poll()) != null) {
            if (result.containsKey(info.className)) continue;
            result.put(info.className, info);
            info.parents.forEach(queue::add);
        }
        return result.values();
    }

    @NotNull
    private BytecodeAnnotationAnnotationValue toAnnotationValue(@NotNull AnnotationNode annotationNode) {
        ClassNode annotationClassNode;
        BytecodeAnnotationAnnotationValue result = new BytecodeAnnotationAnnotationValue(Type.getType(annotationNode.desc).getClassName());
        if (annotationNode.values != null) {
            for (int index = 0; index < annotationNode.values.size(); index += 2) {
                result.setField((String)annotationNode.values.get(index), this.toAnnotationValue(annotationNode.values.get(index + 1)));
            }
        }
        if ((annotationClassNode = this.getClassNode(result.getClassName())) != null && annotationClassNode.methods != null) {
            annotationClassNode.methods.forEach(methodNode -> {
                if (methodNode.annotationDefault != null && result.getField(methodNode.name) == null) {
                    result.setField(methodNode.name, this.toAnnotationValue(methodNode.annotationDefault));
                }
            });
        }
        return result;
    }

    @NotNull
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    private BytecodeAnnotationValue toAnnotationValue(@NotNull Object value) {
        if (value instanceof Byte) {
            return new BytecodeAnnotationByteValue((Byte)value);
        }
        if (value instanceof Boolean) {
            return new BytecodeAnnotationBooleanValue((Boolean)value);
        }
        if (value instanceof Character) {
            return new BytecodeAnnotationCharValue(((Character)value).charValue());
        }
        if (value instanceof Short) {
            return new BytecodeAnnotationShortValue((Short)value);
        }
        if (value instanceof Integer) {
            return new BytecodeAnnotationIntValue((Integer)value);
        }
        if (value instanceof Long) {
            return new BytecodeAnnotationLongValue((Long)value);
        }
        if (value instanceof Float) {
            return new BytecodeAnnotationFloatValue(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new BytecodeAnnotationDoubleValue((Double)value);
        }
        if (value instanceof String) {
            return new BytecodeAnnotationStringValue((String)value);
        }
        if (value instanceof Type) {
            return new BytecodeAnnotationClassValue(((Type)value).getClassName());
        }
        if (value instanceof String[]) {
            return new BytecodeAnnotationEnumValue(Type.getType(((String[])value)[0]).getClassName(), ((String[])value)[1]);
        }
        if (value instanceof AnnotationNode) {
            return this.toAnnotationValue((AnnotationNode)value);
        }
        if (value instanceof List) {
            return this.toAnnotationValue((List)value);
        }
        throw new IllegalArgumentException("Unsupported annotation value: " + value);
    }

    @NotNull
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX", "UTA_USE_TO_ARRAY"})
    private BytecodeAnnotationValue toAnnotationValue(@NotNull List<?> values) {
        Object firstValue = values.get(0);
        if (firstValue instanceof Byte) {
            byte[] typedValues = new byte[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (Byte)values.get(i);
            }
            return new BytecodeAnnotationBytesArrayValue(typedValues);
        }
        if (firstValue instanceof Boolean) {
            boolean[] typedValues = new boolean[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (Boolean)values.get(i);
            }
            return new BytecodeAnnotationBooleansArrayValue(typedValues);
        }
        if (firstValue instanceof Character) {
            char[] typedValues = new char[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = ((Character)values.get(i)).charValue();
            }
            return new BytecodeAnnotationCharsArrayValue(typedValues);
        }
        if (firstValue instanceof Short) {
            short[] typedValues = new short[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (Short)values.get(i);
            }
            return new BytecodeAnnotationShortsArrayValue(typedValues);
        }
        if (firstValue instanceof Integer) {
            int[] typedValues = new int[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (Integer)values.get(i);
            }
            return new BytecodeAnnotationIntsArrayValue(typedValues);
        }
        if (firstValue instanceof Long) {
            long[] typedValues = new long[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (Long)values.get(i);
            }
            return new BytecodeAnnotationLongsArrayValue(typedValues);
        }
        if (firstValue instanceof Float) {
            float[] typedValues = new float[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = ((Float)values.get(i)).floatValue();
            }
            return new BytecodeAnnotationFloatsArrayValue(typedValues);
        }
        if (firstValue instanceof Double) {
            double[] typedValues = new double[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (Double)values.get(i);
            }
            return new BytecodeAnnotationDoublesArrayValue(typedValues);
        }
        if (firstValue instanceof String) {
            String[] typedValues = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = (String)values.get(i);
            }
            return new BytecodeAnnotationStringsArrayValue(typedValues);
        }
        if (firstValue instanceof Type) {
            String[] typedValues = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = ((Type)values.get(i)).getClassName();
            }
            return new BytecodeAnnotationClassesArrayValue(typedValues);
        }
        if (firstValue instanceof String[]) {
            BytecodeAnnotationEnumValue[] typedValues = new BytecodeAnnotationEnumValue[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                typedValues[i] = new BytecodeAnnotationEnumValue(Type.getType(((String[])value)[0]).getClassName(), ((String[])value)[1]);
            }
            return new BytecodeAnnotationEnumsArrayValue(typedValues);
        }
        if (firstValue instanceof AnnotationNode) {
            BytecodeAnnotationAnnotationValue[] typedValues = new BytecodeAnnotationAnnotationValue[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                typedValues[i] = this.toAnnotationValue((AnnotationNode)values.get(i));
            }
            return new BytecodeAnnotationAnnotationsArrayValue(typedValues);
        }
        throw new IllegalArgumentException("Unsupported annotation value: " + values);
    }

    @NotNull
    private static byte[] toByteArray(@NotNull InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private static boolean isLangCoreClass(@NotNull String className) {
        if (className.startsWith("java.lang.")) {
            return true;
        }
        if (className.startsWith("java/lang/")) {
            return true;
        }
        if (className.startsWith("Ljava/lang/")) {
            return true;
        }
        if (className.startsWith("jdk.")) {
            return true;
        }
        if (className.startsWith("jdk/")) {
            return true;
        }
        if (className.startsWith("Ljdk/")) {
            return true;
        }
        if (className.startsWith("kotlin.")) {
            return true;
        }
        if (className.startsWith("kotlin/")) {
            return true;
        }
        if (className.startsWith("Lkotlin/")) {
            return true;
        }
        if (className.startsWith("groovy.")) {
            return true;
        }
        if (className.startsWith("groovy/")) {
            return true;
        }
        if (className.startsWith("Lgroovy/")) {
            return true;
        }
        if (className.startsWith("scala.")) {
            return true;
        }
        if (className.startsWith("scala/")) {
            return true;
        }
        return className.startsWith("Lscala/");
    }

    @NotNull
    private static String computeKey(@NotNull FieldNode fieldNode) {
        return fieldNode.name;
    }

    @NotNull
    private static String computeKey(@NotNull MethodNode methodNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodNode.name);
        sb.append('(');
        Type[] paramTypes = Type.getArgumentTypes(methodNode.desc);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i == 1) {
                sb.append(", ");
            }
            sb.append(paramTypes[i].getDescriptor());
        }
        sb.append(')');
        return sb.toString();
    }
}

