/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnnotationEnumValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String declaringClassName;
    @NotNull
    private String name;

    @Contract(value="null,_->fail; _,null->fail")
    public BytecodeAnnotationEnumValue(@NotNull String declaringClassName, @NotNull String name) {
        this.declaringClassName = Objects.requireNonNull(declaringClassName);
        this.name = Objects.requireNonNull(name);
    }

    @NotNull
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    @Contract(value="null->fail")
    public void setDeclaringClassName(@NotNull String declaringClassName) {
        this.declaringClassName = Objects.requireNonNull(declaringClassName);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Contract(value="null->fail")
    public void setName(@NotNull String name) {
        this.name = Objects.requireNonNull(name);
    }

    @NotNull
    public String toString() {
        return this.declaringClassName + '.' + this.name;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationEnumValue)) {
            return false;
        }
        BytecodeAnnotationEnumValue that = (BytecodeAnnotationEnumValue)o;
        return this.declaringClassName.equals(that.declaringClassName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.declaringClassName.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationEnumValue asEnum() {
        return this;
    }

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    private BytecodeAnnotationEnumValue() {
        this.declaringClassName = null;
        this.name = null;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.declaringClassName == null) {
            throw new InvalidObjectException("declaringClassName is null");
        }
        if (this.name == null) {
            throw new InvalidObjectException("name is null");
        }
    }
}

