/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Arrays;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class BytecodeAnnotationClassesArrayValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final String[] EMPTY = new String[0];
    private static final long serialVersionUID = 1L;
    @NotNull
    private String[] classNames = EMPTY;

    public BytecodeAnnotationClassesArrayValue() {
    }

    @Contract(value="null->fail")
    public BytecodeAnnotationClassesArrayValue(String ... classNames) {
        Objects.requireNonNull(classNames);
        for (int i = 0; i < classNames.length; ++i) {
            Objects.requireNonNull(classNames[i], "classNames[" + i + ']');
        }
        this.classNames = classNames;
    }

    @NotNull
    public String[] getClassNames() {
        return this.classNames;
    }

    @Contract(value="null->fail")
    public void setClassNames(@NotNull String[] classNames) {
        Objects.requireNonNull(classNames);
        for (int i = 0; i < classNames.length; ++i) {
            Objects.requireNonNull(classNames[i], "classNames[" + i + ']');
        }
        this.classNames = classNames;
    }

    @NotNull
    @Contract(value="null->fail")
    public BytecodeAnnotationClassesArrayValue addItem(@NotNull String item) {
        String[] newValue = new String[this.classNames.length + 1];
        System.arraycopy(this.classNames, 0, newValue, 0, this.classNames.length);
        newValue[this.classNames.length] = Objects.requireNonNull(item);
        this.classNames = newValue;
        return this;
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.classNames);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationClassesArrayValue)) {
            return false;
        }
        BytecodeAnnotationClassesArrayValue that = (BytecodeAnnotationClassesArrayValue)o;
        return Arrays.equals(this.classNames, that.classNames);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getClassNames());
    }

    @Override
    public boolean isClassesArray() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationClassesArrayValue asClassesArray() {
        return this;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.classNames == null) {
            throw new InvalidObjectException("classNames is null");
        }
        for (int i = 0; i < this.classNames.length; ++i) {
            Objects.requireNonNull(this.classNames[i], "classNames[" + i + ']');
        }
    }
}

