/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Arrays;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class BytecodeAnnotationCharsArrayValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final char[] EMPTY = new char[0];
    private static final long serialVersionUID = 1L;
    @NotNull
    private char[] value = EMPTY;

    public BytecodeAnnotationCharsArrayValue() {
    }

    @Contract(value="null->fail")
    public BytecodeAnnotationCharsArrayValue(char ... value) {
        this.value = Objects.requireNonNull(value);
    }

    @NotNull
    public char[] getValue() {
        return this.value;
    }

    @Contract(value="null->fail")
    public void setValue(@NotNull char[] value) {
        this.value = Objects.requireNonNull(value);
    }

    @NotNull
    public BytecodeAnnotationCharsArrayValue addItem(char item) {
        char[] newValue = new char[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = item;
        this.value = newValue;
        return this;
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationCharsArrayValue)) {
            return false;
        }
        BytecodeAnnotationCharsArrayValue that = (BytecodeAnnotationCharsArrayValue)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValue());
    }

    @Override
    public boolean isCharsArray() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationCharsArrayValue asCharsArray() {
        return this;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.value == null) {
            throw new InvalidObjectException("value is null");
        }
    }
}

