/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnnotationAnnotationValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String className;
    @NotNull
    private Map<String, BytecodeAnnotationValue> fields;

    @NotNull
    @Contract(value="null->fail")
    private static Map<String, BytecodeAnnotationValue> checkFields(@NotNull Map<String, BytecodeAnnotationValue> fields) {
        Objects.requireNonNull(fields);
        for (Map.Entry<String, BytecodeAnnotationValue> entry : fields.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException();
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("fields[" + entry.getKey() + ']');
        }
        return fields;
    }

    @Contract(value="null,_->fail; _,null->fail")
    public BytecodeAnnotationAnnotationValue(@NotNull String className, @NotNull Map<String, BytecodeAnnotationValue> fields) {
        this.className = Objects.requireNonNull(className);
        this.fields = BytecodeAnnotationAnnotationValue.checkFields(fields);
    }

    @Contract(value="null->fail")
    public BytecodeAnnotationAnnotationValue(@NotNull String className) {
        this(className, new LinkedHashMap<String, BytecodeAnnotationValue>());
    }

    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Contract(value="null->fail")
    public void setClassName(@NotNull String className) {
        this.className = Objects.requireNonNull(className);
    }

    @NotNull
    public Map<String, BytecodeAnnotationValue> getFields() {
        return this.fields;
    }

    @Contract(value="null->fail")
    public void setFields(@NotNull Map<String, BytecodeAnnotationValue> fields) {
        this.fields = BytecodeAnnotationAnnotationValue.checkFields(fields);
    }

    @Nullable
    public BytecodeAnnotationValue getField(@NotNull String field) {
        return this.fields.get(field);
    }

    @NotNull
    @Contract(value="null,_->fail; _,null->fail")
    public BytecodeAnnotationAnnotationValue setField(@NotNull String field, @NotNull BytecodeAnnotationValue value) {
        this.fields.put(Objects.requireNonNull(field), Objects.requireNonNull(value));
        return this;
    }

    @NotNull
    public String toString() {
        return this.className + this.fields;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationAnnotationValue)) {
            return false;
        }
        BytecodeAnnotationAnnotationValue that = (BytecodeAnnotationAnnotationValue)o;
        return this.className.equals(that.className) && this.fields.equals(that.fields);
    }

    public int hashCode() {
        return this.className.hashCode() * 31 + this.fields.hashCode();
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationAnnotationValue asAnnotation() {
        return this;
    }

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    private BytecodeAnnotationAnnotationValue() {
        this.className = null;
        this.fields = null;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.className == null) {
            throw new InvalidObjectException("className is null");
        }
        BytecodeAnnotationAnnotationValue.checkFields(this.fields);
        for (Map.Entry<String, BytecodeAnnotationValue> entry : this.fields.entrySet()) {
            BytecodeAnnotationValue value = entry.getValue();
            if (!(value instanceof ObjectInputValidation)) continue;
            try {
                ((ObjectInputValidation)((Object)value)).validateObject();
            }
            catch (InvalidObjectException e) {
                throw new InvalidObjectException("fields[" + entry.getKey() + "]" + e.getMessage());
            }
        }
    }
}

