/*
 * Decompiled with CFR 0.152.
 */
package name.remal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import name.remal.UncheckedCast;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowableUtils {
    @NotNull
    private static <T extends Throwable> @NotNull List<@NotNull T> findImpl(@NotNull Throwable rootThrowable, @NotNull Class<T> type, boolean doReturnOnlyFirst) {
        Throwable throwable;
        List result = null;
        HashSet<Throwable> processedThrowables = new HashSet<Throwable>();
        processedThrowables.add(rootThrowable);
        LinkedList<Throwable> throwablesQueue = new LinkedList<Throwable>();
        throwablesQueue.add(rootThrowable);
        while ((throwable = (Throwable)throwablesQueue.poll()) != null) {
            Throwable cause;
            if (type.isInstance(throwable)) {
                if (doReturnOnlyFirst) {
                    return Collections.singletonList(UncheckedCast.uncheckedCast(throwable));
                }
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(UncheckedCast.uncheckedCast(throwable));
            }
            if ((cause = throwable.getCause()) != null && processedThrowables.add(cause)) {
                throwablesQueue.add(cause);
            }
            for (Throwable supressed : throwable.getSuppressed()) {
                if (!processedThrowables.add(supressed)) continue;
                throwablesQueue.add(supressed);
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    @NotNull
    public static <T extends Throwable> @NotNull List<@NotNull T> findAll(@NotNull Throwable throwable, @NotNull Class<T> type) {
        return ThrowableUtils.findImpl(throwable, type, false);
    }

    @Nullable
    public static <T extends Throwable> T findFirst(@NotNull Throwable throwable, @NotNull Class<T> type) {
        List<T> list = ThrowableUtils.findImpl(throwable, type, true);
        return (T)(!list.isEmpty() ? (Throwable)list.get(0) : null);
    }

    @Nullable
    public static <T extends Throwable> T findLast(@NotNull Throwable throwable, @NotNull Class<T> type) {
        List<T> list = ThrowableUtils.findImpl(throwable, type, false);
        return (T)(!list.isEmpty() ? (Throwable)list.get(list.size() - 1) : null);
    }

    public static boolean contains(@NotNull Throwable throwable, @NotNull Class<? extends Throwable> type) {
        return ThrowableUtils.findFirst(throwable, type) != null;
    }
}

