/*
 * Decompiled with CFR 0.152.
 */
package name.remal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import name.remal.SneakyThrow;
import name.remal.UncheckedCast;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Services {
    @NotNull
    private static <T> @NotNull List<@NotNull T> iterableToList(@NotNull Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : iterable) {
            list.add(element);
        }
        return Collections.unmodifiableList(list);
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> loadServicesList(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName, @Nullable ClassLoader classLoader) {
        return Services.iterableToList(Services.loadServices(serviceType, serviceSubtypeName, classLoader));
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> loadServicesList(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName) {
        return Services.iterableToList(Services.loadServices(serviceType, serviceSubtypeName));
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> loadServicesList(@NotNull Class<T> serviceType, @Nullable ClassLoader classLoader) {
        return Services.iterableToList(Services.loadServices(serviceType, classLoader));
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> loadServicesList(@NotNull Class<T> serviceType) {
        return Services.iterableToList(Services.loadServices(serviceType));
    }

    @NotNull
    public static <T> @NotNull Iterable<@NotNull T> loadServices(final @NotNull Class<T> serviceType, @Nullable String serviceSubtypeName, @Nullable ClassLoader classLoader) {
        Iterable result = () -> {
            final Iterator implementationClasses = Services.loadImplementationClasses(serviceType, serviceSubtypeName, classLoader).iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return implementationClasses.hasNext();
                }

                @Override
                public T next() {
                    Class implementationClass = (Class)implementationClasses.next();
                    try {
                        return implementationClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new ServiceConfigurationError(String.format("%s: Implementation class %s can't be instantiated", serviceType.getName(), implementationClass.getName()), e);
                    }
                }
            };
        };
        if (Comparable.class.isAssignableFrom(serviceType)) {
            ArrayList list = new ArrayList();
            for (Object impl : result) {
                list.add(impl);
            }
            Collections.sort((List)UncheckedCast.uncheckedCast(list));
            result = list;
        }
        return result;
    }

    @NotNull
    public static <T> @NotNull Iterable<@NotNull T> loadServices(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName) {
        return Services.loadServices(serviceType, serviceSubtypeName, null);
    }

    @NotNull
    public static <T> @NotNull Iterable<@NotNull T> loadServices(@NotNull Class<T> serviceType, @Nullable ClassLoader classLoader) {
        return Services.loadServices(serviceType, null, classLoader);
    }

    @NotNull
    public static <T> @NotNull Iterable<@NotNull T> loadServices(@NotNull Class<T> serviceType) {
        return Services.loadServices(serviceType, null, null);
    }

    @NotNull
    public static <T, R extends T> @NotNull List<@NotNull Class<R>> loadImplementationClassesList(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName, @Nullable ClassLoader classLoader) {
        return Services.iterableToList(Services.loadImplementationClasses(serviceType, serviceSubtypeName, classLoader));
    }

    @NotNull
    public static <T, R extends T> @NotNull List<@NotNull Class<R>> loadImplementationClassesList(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName) {
        return Services.iterableToList(Services.loadImplementationClasses(serviceType, serviceSubtypeName));
    }

    @NotNull
    public static <T, R extends T> @NotNull List<@NotNull Class<R>> loadImplementationClassesList(@NotNull Class<T> serviceType, @Nullable ClassLoader classLoader) {
        return Services.iterableToList(Services.loadImplementationClasses(serviceType, classLoader));
    }

    @NotNull
    public static <T, R extends T> @NotNull List<@NotNull Class<R>> loadImplementationClassesList(@NotNull Class<T> serviceType) {
        return Services.iterableToList(Services.loadImplementationClasses(serviceType));
    }

    @NotNull
    public static <T, R extends T> @NotNull Iterable<@NotNull Class<R>> loadImplementationClasses(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName, @Nullable ClassLoader classLoader) {
        String trueServiceSubtypeName = serviceSubtypeName != null ? serviceSubtypeName : serviceType.getName();
        ClassLoader trueClassLoader = classLoader != null ? classLoader : serviceType.getClassLoader();
        Stream<Class> stream = Services.readServiceLines("META-INF/services/" + trueServiceSubtypeName, classLoader).map(name -> {
            try {
                return trueClassLoader.loadClass((String)name);
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new ServiceConfigurationError(String.format("%s: Implementation class %s can't be found", trueServiceSubtypeName, name), e);
            }
        }).map(clazz -> {
            if (!serviceType.isAssignableFrom((Class<?>)clazz)) {
                throw new ServiceConfigurationError(String.format("%s: Implementation class %s isn't a subtype", trueServiceSubtypeName, clazz.getName()));
            }
            return (Class)UncheckedCast.uncheckedCast(clazz);
        });
        return stream::iterator;
    }

    @NotNull
    public static <T, R extends T> @NotNull Iterable<@NotNull Class<R>> loadImplementationClasses(@NotNull Class<T> serviceType, @Nullable String serviceSubtypeName) {
        return Services.loadImplementationClasses(serviceType, serviceSubtypeName, null);
    }

    @NotNull
    public static <T, R extends T> @NotNull Iterable<@NotNull Class<R>> loadImplementationClasses(@NotNull Class<T> serviceType, @Nullable ClassLoader classLoader) {
        return Services.loadImplementationClasses(serviceType, null, classLoader);
    }

    @NotNull
    public static <T, R extends T> @NotNull Iterable<@NotNull Class<R>> loadImplementationClasses(@NotNull Class<T> serviceType) {
        return Services.loadImplementationClasses(serviceType, null, null);
    }

    @NotNull
    public static @NotNull Stream<@NotNull String> readServiceLines(@NotNull String resourcePath, @Nullable ClassLoader classLoader) {
        Enumeration<URL> resourceURLs;
        if (classLoader == null) {
            classLoader = Services.class.getClassLoader();
        }
        try {
            resourceURLs = classLoader.getResources(resourcePath);
        }
        catch (Throwable throwable) {
            throw SneakyThrow.sneakyThrow(throwable);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<URL>(){

            @Override
            public boolean hasNext() {
                return resourceURLs.hasMoreElements();
            }

            @Override
            public URL next() {
                return (URL)resourceURLs.nextElement();
            }
        }, 272), false).flatMap(Services::readServiceLines).distinct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static @NotNull Stream<@NotNull String> readServiceLines(@NotNull URL resourceURL) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            URLConnection urlConnection = resourceURL.openConnection();
            urlConnection.setUseCaches(false);
            try (InputStream inputStream = urlConnection.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int commentPos = line.indexOf(35);
                    if (0 <= commentPos) {
                        line = line.substring(0, commentPos);
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
            }
            finally {
                if (urlConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)urlConnection).disconnect();
                }
            }
            return lines.stream();
        }
        catch (Throwable throwable) {
            throw SneakyThrow.sneakyThrow(throwable);
        }
    }

    @NotNull
    public static @NotNull Stream<@NotNull String> readServiceLines(@NotNull String resourcePath) {
        return Services.readServiceLines(resourcePath, null);
    }
}

