@file:name.remal.gradle_plugins.api.ExcludeFromCodeCoverage
package name.remal
import name.remal.log.LogUtils

fun isTraceLogEnabled(loggerName: String) = LogUtils.isTraceLogEnabled(loggerName)
fun Class<*>.isTraceLogEnabled() = LogUtils.isTraceLogEnabled(this)

fun logTrace(loggerName: String, message: String) = LogUtils.logTrace(loggerName, message)
fun Class<*>.logTrace(message: String) = LogUtils.logTrace(this, message)

fun logTrace(loggerName: String, message: String, throwable: Throwable) = LogUtils.logTrace(loggerName, message, throwable)
fun Class<*>.logTrace(message: String, throwable: Throwable) = LogUtils.logTrace(this, message, throwable)

fun logTrace(loggerName: String, throwable: Throwable) = LogUtils.logTrace(loggerName, throwable)
fun Class<*>.logTrace(throwable: Throwable) = LogUtils.logTrace(this, throwable)

fun isDebugLogEnabled(loggerName: String) = LogUtils.isDebugLogEnabled(loggerName)
fun Class<*>.isDebugLogEnabled() = LogUtils.isDebugLogEnabled(this)

fun logDebug(loggerName: String, message: String) = LogUtils.logDebug(loggerName, message)
fun Class<*>.logDebug(message: String) = LogUtils.logDebug(this, message)

fun logDebug(loggerName: String, message: String, throwable: Throwable) = LogUtils.logDebug(loggerName, message, throwable)
fun Class<*>.logDebug(message: String, throwable: Throwable) = LogUtils.logDebug(this, message, throwable)

fun logDebug(loggerName: String, throwable: Throwable) = LogUtils.logDebug(loggerName, throwable)
fun Class<*>.logDebug(throwable: Throwable) = LogUtils.logDebug(this, throwable)

fun isInfoLogEnabled(loggerName: String) = LogUtils.isInfoLogEnabled(loggerName)
fun Class<*>.isInfoLogEnabled() = LogUtils.isInfoLogEnabled(this)

fun logInfo(loggerName: String, message: String) = LogUtils.logInfo(loggerName, message)
fun Class<*>.logInfo(message: String) = LogUtils.logInfo(this, message)

fun logInfo(loggerName: String, message: String, throwable: Throwable) = LogUtils.logInfo(loggerName, message, throwable)
fun Class<*>.logInfo(message: String, throwable: Throwable) = LogUtils.logInfo(this, message, throwable)

fun logInfo(loggerName: String, throwable: Throwable) = LogUtils.logInfo(loggerName, throwable)
fun Class<*>.logInfo(throwable: Throwable) = LogUtils.logInfo(this, throwable)

fun isWarnLogEnabled(loggerName: String) = LogUtils.isWarnLogEnabled(loggerName)
fun Class<*>.isWarnLogEnabled() = LogUtils.isWarnLogEnabled(this)

fun logWarn(loggerName: String, message: String) = LogUtils.logWarn(loggerName, message)
fun Class<*>.logWarn(message: String) = LogUtils.logWarn(this, message)

fun logWarn(loggerName: String, message: String, throwable: Throwable) = LogUtils.logWarn(loggerName, message, throwable)
fun Class<*>.logWarn(message: String, throwable: Throwable) = LogUtils.logWarn(this, message, throwable)

fun logWarn(loggerName: String, throwable: Throwable) = LogUtils.logWarn(loggerName, throwable)
fun Class<*>.logWarn(throwable: Throwable) = LogUtils.logWarn(this, throwable)

fun isErrorLogEnabled(loggerName: String) = LogUtils.isErrorLogEnabled(loggerName)
fun Class<*>.isErrorLogEnabled() = LogUtils.isErrorLogEnabled(this)

fun logError(loggerName: String, message: String) = LogUtils.logError(loggerName, message)
fun Class<*>.logError(message: String) = LogUtils.logError(this, message)

fun logError(loggerName: String, message: String, throwable: Throwable) = LogUtils.logError(loggerName, message, throwable)
fun Class<*>.logError(message: String, throwable: Throwable) = LogUtils.logError(this, message, throwable)

fun logError(loggerName: String, throwable: Throwable) = LogUtils.logError(loggerName, throwable)
fun Class<*>.logError(throwable: Throwable) = LogUtils.logError(this, throwable)
