@file:name.remal.gradle_plugins.api.ExcludeFromCodeCoverage
package name.remal
import org.jdom2.*
import org.jdom2.output.*
import org.jetbrains.annotations.Contract

private val defaultXMLOutputter = XMLOutputter()
private val prettyXMLOutputter = XMLOutputter(Format.getPrettyFormat())

@Contract(pure = true)
fun CDATA.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun Comment.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun DocType.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun Document.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun Element.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun EntityRef.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun ProcessingInstruction.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)

@Contract(pure = true)
fun Text.asString(doIndent: Boolean = false): String = (if (doIndent) prettyXMLOutputter else defaultXMLOutputter).outputString(this)
