package name.remal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Contract;
public class PrimitiveTypeUtils {

    @NotNull
    @Contract(pure = true)
    public static Class<?> wrap(@NotNull Class<?> clazz) {
        if (boolean.class == clazz) return java.lang.Boolean.class;
        if (byte.class == clazz) return java.lang.Byte.class;
        if (char.class == clazz) return java.lang.Character.class;
        if (double.class == clazz) return java.lang.Double.class;
        if (float.class == clazz) return java.lang.Float.class;
        if (int.class == clazz) return java.lang.Integer.class;
        if (long.class == clazz) return java.lang.Long.class;
        if (short.class == clazz) return java.lang.Short.class;
        if (void.class == clazz) return java.lang.Void.class;
        return clazz;
    }

    @NotNull
    @Contract(pure = true)
    public static Class<?> unwrap(@NotNull Class<?> clazz) {
        if (java.lang.Boolean.class == clazz) return boolean.class;
        if (java.lang.Byte.class == clazz) return byte.class;
        if (java.lang.Character.class == clazz) return char.class;
        if (java.lang.Double.class == clazz) return double.class;
        if (java.lang.Float.class == clazz) return float.class;
        if (java.lang.Integer.class == clazz) return int.class;
        if (java.lang.Long.class == clazz) return long.class;
        if (java.lang.Short.class == clazz) return short.class;
        if (java.lang.Void.class == clazz) return void.class;
        return clazz;
    }

}
