/*
 * Decompiled with CFR 0.152.
 */
package name.remal.tools.common.internal._relocated.com.google.common.collect;

import com.google.j2objc.annotations.Weak;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;
import name.remal.tools.common.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.tools.common.internal._relocated.com.google.common.annotations.GwtIncompatible;
import name.remal.tools.common.internal._relocated.com.google.common.base.Preconditions;
import name.remal.tools.common.internal._relocated.com.google.common.collect.ImmutableList;
import name.remal.tools.common.internal._relocated.com.google.common.collect.ImmutableMap;
import name.remal.tools.common.internal._relocated.com.google.common.collect.ImmutableSet;
import name.remal.tools.common.internal._relocated.com.google.common.collect.Iterators;
import name.remal.tools.common.internal._relocated.com.google.common.collect.RegularImmutableAsList;
import name.remal.tools.common.internal._relocated.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@RelocatedClass
@GwtCompatible(emulated=true)
abstract class ImmutableMapEntrySet<K, V>
extends ImmutableSet<Map.Entry<K, V>> {
    ImmutableMapEntrySet() {
    }

    abstract ImmutableMap<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            V value = this.map().get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.map().isPartialView();
    }

    @Override
    @GwtIncompatible
    boolean isHashCodeFast() {
        return this.map().isHashCodeFast();
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new EntrySetSerializedForm<K, V>(this.map());
    }

    @RelocatedClass
    @GwtIncompatible
    private static class EntrySetSerializedForm<K, V>
    implements Serializable {
        final ImmutableMap<K, V> map;
        private static final long serialVersionUID = 0L;

        EntrySetSerializedForm(ImmutableMap<K, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.entrySet();
        }
    }

    @RelocatedClass
    static final class RegularEntrySet<K, V>
    extends ImmutableMapEntrySet<K, V> {
        @Weak
        private final transient ImmutableMap<K, V> map;
        private final transient Map.Entry<K, V>[] entries;

        RegularEntrySet(ImmutableMap<K, V> map, Map.Entry<K, V>[] entries) {
            this.map = map;
            this.entries = entries;
        }

        @Override
        ImmutableMap<K, V> map() {
            return this.map;
        }

        @Override
        @GwtIncompatible(value="not used in GWT")
        int copyIntoArray(Object[] dst, int offset) {
            System.arraycopy(this.entries, 0, dst, offset, this.entries.length);
            return offset + this.entries.length;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return Iterators.forArray(this.entries);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this.entries, 1297);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            Preconditions.checkNotNull(action);
            for (Map.Entry<K, V> entry : this.entries) {
                action.accept(entry);
            }
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new RegularImmutableAsList<Map.Entry<K, V>>(this, this.entries);
        }
    }
}

