/*
 * Decompiled with CFR 0.152.
 */
package name.remal.tools.common.internal._relocated.com.google.common.collect;

import java.util.NoSuchElementException;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;
import name.remal.tools.common.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.tools.common.internal._relocated.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@RelocatedClass
@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    @NullableDecl
    private T nextOrNull;

    protected AbstractSequentialIterator(@NullableDecl T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

