/*
 * Decompiled with CFR 0.152.
 */
package name.remal.reflection;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import name.remal.ArrayUtils;
import name.remal.reflection.BootstrapClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedURLClassLoader
extends URLClassLoader {
    @NotNull
    private final LoadingOrderFactory loadingOrderFactory;

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull URL[] urls, @Nullable ClassLoader parent) {
        super(ExtendedURLClassLoader.uniqueURLs(urls), null != parent ? parent : ExtendedURLClassLoader.getSystemClassLoader());
        this.loadingOrderFactory = loadingOrderFactory;
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull URL[] urls, @Nullable ClassLoader parent) {
        this((String __) -> loadingOrder, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull Iterable<URL> urls, @Nullable ClassLoader parent) {
        this(loadingOrderFactory, ExtendedURLClassLoader.iterableUrlsToArray(urls), parent);
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull Iterable<URL> urls, @Nullable ClassLoader parent) {
        this((String __) -> loadingOrder, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull URL[] urls, @Nullable ClassLoader parent) {
        this(LoadingOrder.PARENT_FIRST, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull Iterable<URL> urls, @Nullable ClassLoader parent) {
        this(LoadingOrder.PARENT_FIRST, urls, parent);
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull URL[] urls) {
        this(loadingOrderFactory, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull URL[] urls) {
        this(loadingOrder, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrderFactory loadingOrderFactory, @NotNull Iterable<URL> urls) {
        this(loadingOrderFactory, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull LoadingOrder loadingOrder, @NotNull Iterable<URL> urls) {
        this(loadingOrder, urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull URL[] urls) {
        this(urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    public ExtendedURLClassLoader(@NotNull Iterable<URL> urls) {
        this(urls, ExtendedURLClassLoader.getSystemClassLoader());
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (null == loadedClass) {
                loadedClass = this.findBootstrapClassOrNull(name);
            }
            if (null == loadedClass) {
                LoadingOrder loadingOrder = this.loadingOrderFactory.getLoadingOrder(name);
                if (LoadingOrder.PARENT_FIRST == loadingOrder) {
                    loadedClass = this.findParentClassOrNull(name);
                    if (null == loadedClass) {
                        loadedClass = this.findClassOrNull(name);
                    }
                } else if (LoadingOrder.THIS_FIRST == loadingOrder) {
                    loadedClass = this.findClassOrNull(name);
                    if (null == loadedClass) {
                        loadedClass = this.findParentClassOrNull(name);
                    }
                } else if (LoadingOrder.PARENT_ONLY == loadingOrder) {
                    loadedClass = this.findParentClassOrNull(name);
                } else if (LoadingOrder.THIS_ONLY == loadingOrder) {
                    loadedClass = this.findClassOrNull(name);
                } else {
                    throw new IllegalStateException("Unsupported " + LoadingOrder.class.getSimpleName() + ": " + (Object)((Object)loadingOrder));
                }
            }
            if (null == loadedClass) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    @Nullable
    protected Class<?> findBootstrapClassOrNull(@NotNull String className) {
        try {
            return BootstrapClassLoader.getBootstrapClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    protected Class<?> findClassOrNull(@NotNull String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    protected Class<?> findParentClassOrNull(@NotNull String className) {
        ClassLoader parent = this.getParent();
        if (null == parent) {
            return null;
        }
        try {
            return parent.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public synchronized void addURL(@NotNull URL url) {
        if (!ArrayUtils.contains(this.getURLs(), url)) {
            super.addURL(url);
        }
    }

    @NotNull
    private static URL[] uniqueURLs(@NotNull URL[] urls) {
        return (URL[])Stream.of(urls).distinct().toArray(URL[]::new);
    }

    @NotNull
    private static URL[] iterableUrlsToArray(@NotNull Iterable<URL> urls) {
        if (urls instanceof List) {
            return ((List)urls).toArray(new URL[0]);
        }
        ArrayList<URL> list = new ArrayList<URL>();
        for (URL url : urls) {
            list.add(url);
        }
        return list.toArray(new URL[0]);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    @FunctionalInterface
    public static interface LoadingOrderFactory {
        @NotNull
        public LoadingOrder getLoadingOrder(@NotNull String var1);
    }

    public static enum LoadingOrder {
        PARENT_FIRST,
        THIS_FIRST,
        PARENT_ONLY,
        THIS_ONLY;

    }
}

