/*
 * Decompiled with CFR 0.152.
 */
package name.remal.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Optional;
import java.util.function.Function;
import name.remal.SneakyThrow;
import name.remal.UncheckedCast;
import name.remal.reflection.ExtendedURLClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassLoaderUtils {
    private static final Method ADD_URL_METHOD;

    @Nullable
    public static Package getPackageOrNull(@NotNull ClassLoader classLoader, @NotNull String packageName) {
        return new ClassLoaderWrapper(classLoader).getPackageOrNull(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addURLsToClassLoader(@NotNull ClassLoader classLoader, URL ... urls) {
        if (0 == urls.length) {
            return;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        while (true) {
            if (classLoader instanceof URLClassLoader) {
                ClassLoader classLoader2 = classLoader;
                synchronized (classLoader2) {
                    for (URL url : urls) {
                        try {
                            ADD_URL_METHOD.invoke((Object)classLoader, url);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw SneakyThrow.sneakyThrow(e);
                        }
                    }
                }
                return;
            }
            if (systemClassLoader == classLoader) break;
            if (null != (classLoader = classLoader.getParent())) continue;
            classLoader = systemClassLoader;
        }
        throw new IllegalStateException("New URL can't be added to system ClassLoader: " + systemClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R forInstantiated(@NotNull ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull Function<T, R> action) {
        if (!type.isAssignableFrom(implementationType) || type == implementationType) {
            throw new IllegalArgumentException(implementationType + " is not subtype of " + type);
        }
        String implTypeName = implementationType.getName();
        String implTypeNamePrefix = implTypeName + '$';
        URL sourceURL = Optional.ofNullable(implementationType.getProtectionDomain()).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).orElseThrow(() -> new IllegalStateException(implementationType + ": null == protectionDomain?.codeSource?.location"));
        try {
            Throwable throwable = null;
            try (ExtendedURLClassLoader childClassLoader = new ExtendedURLClassLoader(className -> className.equals(implTypeName) || className.startsWith(implTypeNamePrefix) ? ExtendedURLClassLoader.LoadingOrder.THIS_ONLY : ExtendedURLClassLoader.LoadingOrder.PARENT_ONLY, new URL[]{sourceURL}, classLoader);){
                R r;
                Thread currentThread = Thread.currentThread();
                ClassLoader prevContextClassLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(classLoader);
                try {
                    Object implementation = UncheckedCast.uncheckedCast(((ClassLoader)childClassLoader).loadClass(implementationType.getName()).newInstance());
                    r = action.apply(implementation);
                    currentThread.setContextClassLoader(prevContextClassLoader);
                }
                catch (Throwable throwable2) {
                    try {
                        currentThread.setContextClassLoader(prevContextClassLoader);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                return r;
            }
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    static {
        try {
            ADD_URL_METHOD = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    static class ClassLoaderWrapper
    extends ClassLoader {
        public ClassLoaderWrapper(@NotNull ClassLoader classLoader) {
            super(classLoader);
        }

        @Nullable
        public Package getPackageOrNull(@NotNull String name) {
            return this.getPackage(name);
        }
    }
}

