/*
 * Decompiled with CFR 0.152.
 */
package name.remal.log;

import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final boolean IS_SLF4J_IN_CLASSPATH = LogUtils.isSlf4JInClasspath();

    public static void logTrace(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).trace(message);
        }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logTrace(loggerClass.getName(), message);
    }

    public static void logTrace(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).trace(message, throwable);
        }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logTrace(loggerClass.getName(), message, throwable);
    }

    public static void logTrace(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).trace(throwable.getMessage(), throwable);
        }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logTrace(loggerClass.getName(), throwable);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).debug(message);
        }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logDebug(loggerClass.getName(), message);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).debug(message, throwable);
        }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logDebug(loggerClass.getName(), message, throwable);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).debug(throwable.getMessage(), throwable);
        }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logDebug(loggerClass.getName(), throwable);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).info(message);
        } else {
            System.out.println(message);
        }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logInfo(loggerClass.getName(), message);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).info(message, throwable);
        } else {
            System.out.println(message);
            System.out.println(throwable.toString());
        }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logInfo(loggerClass.getName(), message, throwable);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).info(throwable.getMessage(), throwable);
        } else {
            System.out.println(throwable.toString());
        }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logInfo(loggerClass.getName(), throwable);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).warn(message);
        } else {
            System.err.println(message);
        }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logWarn(loggerClass.getName(), message);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).warn(message, throwable);
        } else {
            System.err.println(message);
            System.err.println(throwable.toString());
        }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logWarn(loggerClass.getName(), message, throwable);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).warn(throwable.getMessage(), throwable);
        } else {
            System.err.println(throwable.toString());
        }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logWarn(loggerClass.getName(), throwable);
    }

    public static void logError(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).error(message);
        } else {
            System.err.println(message);
        }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logError(loggerClass.getName(), message);
    }

    public static void logError(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).error(message, throwable);
        } else {
            System.err.println(message);
            System.err.println(throwable.toString());
        }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logError(loggerClass.getName(), message, throwable);
    }

    public static void logError(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).error(throwable.getMessage(), throwable);
        } else {
            System.err.println(throwable.toString());
        }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logError(loggerClass.getName(), throwable);
    }

    private static boolean isSlf4JInClasspath() {
        try {
            Class.forName("org.slf4j.LoggerFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

