/*
 * Decompiled with CFR 0.152.
 */
package name.remal;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PrimitiveArrayConverters {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull byte[] array) {
        if (0 == array.length) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull double[] array) {
        if (0 == array.length) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Math.toIntExact((long)array[i]);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull float[] array) {
        if (0 == array.length) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (int)array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull int[] array) {
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull long[] array) {
        if (0 == array.length) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Math.toIntExact(array[i]);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull short[] array) {
        if (0 == array.length) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] toLongArray(@NotNull byte[] array) {
        if (0 == array.length) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] toLongArray(@NotNull double[] array) {
        if (0 == array.length) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (long)array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] toLongArray(@NotNull float[] array) {
        if (0 == array.length) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (long)array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] toLongArray(@NotNull int[] array) {
        if (0 == array.length) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] toLongArray(@NotNull long[] array) {
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] toLongArray(@NotNull short[] array) {
        if (0 == array.length) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static double[] toDoubleArray(@NotNull byte[] array) {
        if (0 == array.length) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static double[] toDoubleArray(@NotNull double[] array) {
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static double[] toDoubleArray(@NotNull float[] array) {
        if (0 == array.length) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static double[] toDoubleArray(@NotNull int[] array) {
        if (0 == array.length) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static double[] toDoubleArray(@NotNull long[] array) {
        if (0 == array.length) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static double[] toDoubleArray(@NotNull short[] array) {
        if (0 == array.length) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }
}

