/*
 * Decompiled with CFR 0.152.
 */
package name.remal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import name.remal.SneakyThrow;
import name.remal.gradle_plugins.api.ExcludeFromCodeCoverage;
import name.remal.tools.common.internal._relocated.org.apache.commons.codec.DecoderException;
import name.remal.tools.common.internal._relocated.org.apache.commons.codec.binary.Base64;
import name.remal.tools.common.internal._relocated.org.apache.commons.codec.binary.Hex;
import name.remal.tools.common.internal._relocated.org.apache.commons.codec.net.URLCodec;
import org.jetbrains.annotations.NotNull;

@ExcludeFromCodeCoverage
public class Codecs {
    @NotNull
    public static String encodeHex(@NotNull byte[] data) {
        return Hex.encodeHexString(data, true);
    }

    @NotNull
    public static byte[] decodeHex(@NotNull String data) {
        try {
            return Hex.decodeHex(data);
        }
        catch (DecoderException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static String encodeBase64(@NotNull byte[] data) {
        return Base64.encodeBase64String(data);
    }

    @NotNull
    public static String encodeBase64URLSafe(@NotNull byte[] data) {
        return Base64.encodeBase64URLSafeString(data);
    }

    @NotNull
    public static byte[] decodeBase64(@NotNull String data) {
        return Base64.decodeBase64(data);
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String data, @NotNull Charset charset) {
        try {
            return new URLCodec().encode(data, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String data) {
        return Codecs.encodeURIComponent(data, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String decodeURIComponent(@NotNull String data, @NotNull Charset charset) {
        try {
            return new URLCodec().decode(data, charset.name());
        }
        catch (UnsupportedEncodingException | DecoderException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static String decodeURIComponent(@NotNull String data) {
        return Codecs.decodeURIComponent(data, StandardCharsets.UTF_8);
    }

    private static void update(@NotNull MessageDigest digest, @NotNull InputStream data) {
        try {
            int read;
            byte[] buffer = new byte[1024];
            while (-1 < (read = data.read(buffer, 0, buffer.length))) {
                digest.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static MessageDigest newMd5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static String md5(@NotNull byte[] data) {
        return Codecs.encodeHex(Codecs.newMd5Digest().digest(data));
    }

    @NotNull
    public static String md5(@NotNull String data, @NotNull Charset charset) {
        return Codecs.md5(data.getBytes(charset));
    }

    @NotNull
    public static String md5(@NotNull String data) {
        return Codecs.md5(data, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String md5(@NotNull InputStream data) {
        MessageDigest digest = Codecs.newMd5Digest();
        Codecs.update(digest, data);
        return Codecs.encodeHex(digest.digest());
    }

    @NotNull
    public static MessageDigest newSha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static String sha256(@NotNull byte[] data) {
        return Codecs.encodeHex(Codecs.newSha256Digest().digest(data));
    }

    @NotNull
    public static String sha256(@NotNull String data, @NotNull Charset charset) {
        return Codecs.sha256(data.getBytes(charset));
    }

    @NotNull
    public static String sha256(@NotNull String data) {
        return Codecs.sha256(data, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String sha256(@NotNull InputStream data) {
        MessageDigest digest = Codecs.newSha256Digest();
        Codecs.update(digest, data);
        return Codecs.encodeHex(digest.digest());
    }

    @NotNull
    public static MessageDigest newSha512Digest() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    public static String sha512(@NotNull byte[] data) {
        return Codecs.encodeHex(Codecs.newSha512Digest().digest(data));
    }

    @NotNull
    public static String sha512(@NotNull String data, @NotNull Charset charset) {
        return Codecs.sha512(data.getBytes(charset));
    }

    @NotNull
    public static String sha512(@NotNull String data) {
        return Codecs.sha512(data, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String sha512(@NotNull InputStream data) {
        MessageDigest digest = Codecs.newSha512Digest();
        Codecs.update(digest, data);
        return Codecs.encodeHex(digest.digest());
    }
}

