@file:name.remal.gradle_plugins.api.ExcludeFromCodeCoverage
package name.remal
import org.jetbrains.annotations.Contract

@Contract(pure = true)
fun escapeCsv(string: String): String = StringEscapeUtils.escapeCsv(string)!!

@JvmName("escapeCsvNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeCsv(string: String?): String? = StringEscapeUtils.escapeCsv(string)

@Contract(pure = true)
fun escapeEcmaScript(string: String): String = StringEscapeUtils.escapeEcmaScript(string)!!

@JvmName("escapeEcmaScriptNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeEcmaScript(string: String?): String? = StringEscapeUtils.escapeEcmaScript(string)

@Contract(pure = true)
fun escapeHtml3(string: String): String = StringEscapeUtils.escapeHtml3(string)!!

@JvmName("escapeHtml3Nullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeHtml3(string: String?): String? = StringEscapeUtils.escapeHtml3(string)

@Contract(pure = true)
fun escapeHtml4(string: String): String = StringEscapeUtils.escapeHtml4(string)!!

@JvmName("escapeHtml4Nullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeHtml4(string: String?): String? = StringEscapeUtils.escapeHtml4(string)

@Contract(pure = true)
fun escapeJava(string: String): String = StringEscapeUtils.escapeJava(string)!!

@JvmName("escapeJavaNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeJava(string: String?): String? = StringEscapeUtils.escapeJava(string)

@Contract(pure = true)
fun escapeJson(string: String): String = StringEscapeUtils.escapeJson(string)!!

@JvmName("escapeJsonNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeJson(string: String?): String? = StringEscapeUtils.escapeJson(string)

@Contract(pure = true)
fun escapeXSI(string: String): String = StringEscapeUtils.escapeXSI(string)!!

@JvmName("escapeXSINullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeXSI(string: String?): String? = StringEscapeUtils.escapeXSI(string)

@Contract(pure = true)
fun unescapeCsv(string: String): String = StringEscapeUtils.unescapeCsv(string)!!

@JvmName("unescapeCsvNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeCsv(string: String?): String? = StringEscapeUtils.unescapeCsv(string)

@Contract(pure = true)
fun unescapeEcmaScript(string: String): String = StringEscapeUtils.unescapeEcmaScript(string)!!

@JvmName("unescapeEcmaScriptNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeEcmaScript(string: String?): String? = StringEscapeUtils.unescapeEcmaScript(string)

@Contract(pure = true)
fun unescapeHtml3(string: String): String = StringEscapeUtils.unescapeHtml3(string)!!

@JvmName("unescapeHtml3Nullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeHtml3(string: String?): String? = StringEscapeUtils.unescapeHtml3(string)

@Contract(pure = true)
fun unescapeHtml4(string: String): String = StringEscapeUtils.unescapeHtml4(string)!!

@JvmName("unescapeHtml4Nullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeHtml4(string: String?): String? = StringEscapeUtils.unescapeHtml4(string)

@Contract(pure = true)
fun unescapeJava(string: String): String = StringEscapeUtils.unescapeJava(string)!!

@JvmName("unescapeJavaNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeJava(string: String?): String? = StringEscapeUtils.unescapeJava(string)

@Contract(pure = true)
fun unescapeJson(string: String): String = StringEscapeUtils.unescapeJson(string)!!

@JvmName("unescapeJsonNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeJson(string: String?): String? = StringEscapeUtils.unescapeJson(string)

@Contract(pure = true)
fun unescapeXSI(string: String): String = StringEscapeUtils.unescapeXSI(string)!!

@JvmName("unescapeXSINullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeXSI(string: String?): String? = StringEscapeUtils.unescapeXSI(string)

@Contract(pure = true)
fun unescapeXml(string: String): String = StringEscapeUtils.unescapeXml(string)!!

@JvmName("unescapeXmlNullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun unescapeXml(string: String?): String? = StringEscapeUtils.unescapeXml(string)

@Contract(pure = true)
fun escapeXml10(string: String): String = StringEscapeUtils.escapeXml10(string)!!

@JvmName("escapeXml10Nullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeXml10(string: String?): String? = StringEscapeUtils.escapeXml10(string)

@Contract(pure = true)
fun escapeXml11(string: String): String = StringEscapeUtils.escapeXml11(string)!!

@JvmName("escapeXml11Nullable")
@Contract(value = "null->null; !null->!null", pure = true)
fun escapeXml11(string: String?): String? = StringEscapeUtils.escapeXml11(string)
