@file:name.remal.gradle_plugins.api.RelocateClasses(CaseFormat::class)
@file:name.remal.gradle_plugins.api.ExcludeFromCodeCoverage
package name.remal
import com.google.common.base.CaseFormat
import com.google.common.base.CaseFormat.*
import org.jetbrains.annotations.Contract

@Contract(pure = true)
fun String.fromLowerHyphenToLowerUnderscore(): String = LOWER_HYPHEN.to(LOWER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromLowerHyphenToLowerCamel(): String = LOWER_HYPHEN.to(LOWER_CAMEL, this)

@Contract(pure = true)
fun String.fromLowerHyphenToUpperCamel(): String = LOWER_HYPHEN.to(UPPER_CAMEL, this)

@Contract(pure = true)
fun String.fromLowerHyphenToUpperUnderscore(): String = LOWER_HYPHEN.to(UPPER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromLowerUnderscoreToLowerHyphen(): String = LOWER_UNDERSCORE.to(LOWER_HYPHEN, this)

@Contract(pure = true)
fun String.fromLowerUnderscoreToLowerCamel(): String = LOWER_UNDERSCORE.to(LOWER_CAMEL, this)

@Contract(pure = true)
fun String.fromLowerUnderscoreToUpperCamel(): String = LOWER_UNDERSCORE.to(UPPER_CAMEL, this)

@Contract(pure = true)
fun String.fromLowerUnderscoreToUpperUnderscore(): String = LOWER_UNDERSCORE.to(UPPER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromLowerCamelToLowerHyphen(): String = LOWER_CAMEL.to(LOWER_HYPHEN, this)

@Contract(pure = true)
fun String.fromLowerCamelToLowerUnderscore(): String = LOWER_CAMEL.to(LOWER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromLowerCamelToUpperCamel(): String = LOWER_CAMEL.to(UPPER_CAMEL, this)

@Contract(pure = true)
fun String.fromLowerCamelToUpperUnderscore(): String = LOWER_CAMEL.to(UPPER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromUpperCamelToLowerHyphen(): String = UPPER_CAMEL.to(LOWER_HYPHEN, this)

@Contract(pure = true)
fun String.fromUpperCamelToLowerUnderscore(): String = UPPER_CAMEL.to(LOWER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromUpperCamelToLowerCamel(): String = UPPER_CAMEL.to(LOWER_CAMEL, this)

@Contract(pure = true)
fun String.fromUpperCamelToUpperUnderscore(): String = UPPER_CAMEL.to(UPPER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromUpperUnderscoreToLowerHyphen(): String = UPPER_UNDERSCORE.to(LOWER_HYPHEN, this)

@Contract(pure = true)
fun String.fromUpperUnderscoreToLowerUnderscore(): String = UPPER_UNDERSCORE.to(LOWER_UNDERSCORE, this)

@Contract(pure = true)
fun String.fromUpperUnderscoreToLowerCamel(): String = UPPER_UNDERSCORE.to(LOWER_CAMEL, this)

@Contract(pure = true)
fun String.fromUpperUnderscoreToUpperCamel(): String = UPPER_UNDERSCORE.to(UPPER_CAMEL, this)
