package name.remal.reflection;

import org.jetbrains.annotations.NotNull;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeProvider<T> {

    @NotNull
    private final Type type;

    protected TypeProvider() {
        Type superclass = getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) throw new IllegalStateException(superclass + " isn't parameterized");
        type = ((ParameterizedType) superclass).getActualTypeArguments()[0];
    }

    @NotNull
    public Type getType() {
        return type;
    }

}
