package name.remal.reflection;

import org.jetbrains.annotations.NotNull;

public final class BootstrapClassLoader extends ClassLoader {

    private static final class InstanceHolder {
        public static final BootstrapClassLoader INSTANCE = new BootstrapClassLoader();
    }

    @NotNull
    public static BootstrapClassLoader getBootstrapClassLoader() {
        return InstanceHolder.INSTANCE;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private BootstrapClassLoader() {
        super(null);
    }

}
