package name.remal

import org.w3c.dom.Document
import org.xml.sax.InputSource
import java.io.File
import java.io.InputStream
import java.io.Reader
import java.net.URI
import java.net.URL
import javax.xml.parsers.DocumentBuilderFactory

private val documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder()

fun newDOMDocument(): Document = documentBuilder.newDocument()

fun parseDOMDocument(inputSource: InputSource): Document = documentBuilder.parse(inputSource)
fun parseDOMDocument(file: File) = parseDOMDocument(newSAXInputSource(file))
fun parseDOMDocument(url: URL) = parseDOMDocument(newSAXInputSource(url))
fun parseDOMDocument(inputStream: InputStream, location: URI? = null) = parseDOMDocument(newSAXInputSource(inputStream, location))
fun parseDOMDocument(reader: Reader, location: URI? = null) = parseDOMDocument(newSAXInputSource(reader, location))
fun parseDOMDocument(string: String, location: URI? = null) = parseDOMDocument(newSAXInputSource(string, location))
