package name.remal

import org.objectweb.asm.tree.*

val MethodNode.unusedLabelNodes: Set<LabelNode>
    get() {
        val instructions = this.instructions ?: return emptySet()
        return buildSet {
            instructions.forEach { if (it is LabelNode) add(it) }

            if (isNotEmpty()) {
                tryCatchBlocks?.forEach { remove(it.start); remove(it.end); remove(it.handler) }
                localVariables?.forEach { remove(it.start); remove(it.end) }
                visibleLocalVariableAnnotations?.forEach { it.start?.let(this::removeAll); it.end?.let(this::removeAll) }
                invisibleLocalVariableAnnotations?.forEach { it.start?.let(this::removeAll); it.end?.let(this::removeAll) }
                instructions.forEach {
                    if (it is JumpInsnNode) remove(it.label)
                    if (it is LookupSwitchInsnNode) {
                        remove(it.dflt)
                        it.labels?.let(this::removeAll)
                    }
                    if (it is TableSwitchInsnNode) {
                        remove(it.dflt)
                        it.labels?.let(this::removeAll)
                    }
                }
            }
        }
    }


data class InstructionNodeContext<out T : AbstractInsnNode>(
    val node: T,
    val previousNode: AbstractInsnNode?,
    val nextNode: AbstractInsnNode?
)

data class InstructionNodeFilter<T : AbstractInsnNode>(
    val nodeType: Class<T>,
    val predicate: ((context: InstructionNodeContext<T>) -> Boolean)? = null
)

fun <T : AbstractInsnNode> Class<T>.toInstructionNodeFilter() = InstructionNodeFilter(this)
