package name.remal
import org.objectweb.asm.tree.*

fun <T1 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, instructionsGenerator: (node1: T1) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 1) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 1) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null

    fun reset() {
        node1 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()

                nextNode = node1!!.next
                val newInstructions = instructionsGenerator(node1!!)
                if (1 <= newInstructions.size()) instructions.insert(node1, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node1) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, instructionsGenerator: (node1: T1) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, instructionsGenerator: (node1: T1, node2: T2) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 2) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 2) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null

    fun reset() {
        node1 = null
        node2 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()

                nextNode = node2!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!)
                if (1 <= newInstructions.size()) instructions.insert(node2, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node2) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, instructionsGenerator: (node1: T1, node2: T2) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, instructionsGenerator: (node1: T1, node2: T2, node3: T3) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 3) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 3) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()

                nextNode = node3!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!)
                if (1 <= newInstructions.size()) instructions.insert(node3, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node3) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, instructionsGenerator: (node1: T1, node2: T2, node3: T3) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 4) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 4) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()

                nextNode = node4!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!)
                if (1 <= newInstructions.size()) instructions.insert(node4, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node4) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 5) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 5) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()

                nextNode = node5!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!)
                if (1 <= newInstructions.size()) instructions.insert(node5, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node5) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 6) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 6) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()

                nextNode = node6!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!)
                if (1 <= newInstructions.size()) instructions.insert(node6, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node6) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 7) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 7) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()

                nextNode = node7!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!)
                if (1 <= newInstructions.size()) instructions.insert(node7, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node7) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 8) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 8) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()

                nextNode = node8!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!)
                if (1 <= newInstructions.size()) instructions.insert(node8, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node8) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 9) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 9) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()

                nextNode = node9!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!)
                if (1 <= newInstructions.size()) instructions.insert(node9, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node9) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 10) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 10) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()

                nextNode = node10!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!)
                if (1 <= newInstructions.size()) instructions.insert(node10, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node10) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 11) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 11) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()

                nextNode = node11!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!)
                if (1 <= newInstructions.size()) instructions.insert(node11, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node11) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 12) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 12) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()

                nextNode = node12!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!)
                if (1 <= newInstructions.size()) instructions.insert(node12, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node12) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 13) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 13) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()

                nextNode = node13!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!)
                if (1 <= newInstructions.size()) instructions.insert(node13, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node13) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 14) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 14) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()

                nextNode = node14!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!)
                if (1 <= newInstructions.size()) instructions.insert(node14, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node14) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, filter15: InstructionNodeFilter<T15>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 15) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 15) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null
    var node15: T15? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
        node15 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()
            } else if (null == node15) {
                if (!filter15.nodeType.isInstance(node)) return@run reset()
                filter15.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node15 = node.uncheckedCast()

                nextNode = node15!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!, node15!!)
                if (1 <= newInstructions.size()) instructions.insert(node15, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node15) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, nodeType15: Class<T15>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), nodeType15.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, filter15: InstructionNodeFilter<T15>, filter16: InstructionNodeFilter<T16>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 16) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 16) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null
    var node15: T15? = null
    var node16: T16? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
        node15 = null
        node16 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()
            } else if (null == node15) {
                if (!filter15.nodeType.isInstance(node)) return@run reset()
                filter15.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node15 = node.uncheckedCast()
            } else if (null == node16) {
                if (!filter16.nodeType.isInstance(node)) return@run reset()
                filter16.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node16 = node.uncheckedCast()

                nextNode = node16!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!, node15!!, node16!!)
                if (1 <= newInstructions.size()) instructions.insert(node16, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node16) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, nodeType15: Class<T15>, nodeType16: Class<T16>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), nodeType15.toInstructionNodeFilter(), nodeType16.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, filter15: InstructionNodeFilter<T15>, filter16: InstructionNodeFilter<T16>, filter17: InstructionNodeFilter<T17>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 17) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 17) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null
    var node15: T15? = null
    var node16: T16? = null
    var node17: T17? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
        node15 = null
        node16 = null
        node17 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()
            } else if (null == node15) {
                if (!filter15.nodeType.isInstance(node)) return@run reset()
                filter15.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node15 = node.uncheckedCast()
            } else if (null == node16) {
                if (!filter16.nodeType.isInstance(node)) return@run reset()
                filter16.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node16 = node.uncheckedCast()
            } else if (null == node17) {
                if (!filter17.nodeType.isInstance(node)) return@run reset()
                filter17.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node17 = node.uncheckedCast()

                nextNode = node17!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!, node15!!, node16!!, node17!!)
                if (1 <= newInstructions.size()) instructions.insert(node17, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node17) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, nodeType15: Class<T15>, nodeType16: Class<T16>, nodeType17: Class<T17>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), nodeType15.toInstructionNodeFilter(), nodeType16.toInstructionNodeFilter(), nodeType17.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode, T18 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, filter15: InstructionNodeFilter<T15>, filter16: InstructionNodeFilter<T16>, filter17: InstructionNodeFilter<T17>, filter18: InstructionNodeFilter<T18>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17, node18: T18) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 18) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 18) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null
    var node15: T15? = null
    var node16: T16? = null
    var node17: T17? = null
    var node18: T18? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
        node15 = null
        node16 = null
        node17 = null
        node18 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()
            } else if (null == node15) {
                if (!filter15.nodeType.isInstance(node)) return@run reset()
                filter15.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node15 = node.uncheckedCast()
            } else if (null == node16) {
                if (!filter16.nodeType.isInstance(node)) return@run reset()
                filter16.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node16 = node.uncheckedCast()
            } else if (null == node17) {
                if (!filter17.nodeType.isInstance(node)) return@run reset()
                filter17.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node17 = node.uncheckedCast()
            } else if (null == node18) {
                if (!filter18.nodeType.isInstance(node)) return@run reset()
                filter18.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node18 = node.uncheckedCast()

                nextNode = node18!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!, node15!!, node16!!, node17!!, node18!!)
                if (1 <= newInstructions.size()) instructions.insert(node18, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node18) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode, T18 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, nodeType15: Class<T15>, nodeType16: Class<T16>, nodeType17: Class<T17>, nodeType18: Class<T18>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17, node18: T18) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), nodeType15.toInstructionNodeFilter(), nodeType16.toInstructionNodeFilter(), nodeType17.toInstructionNodeFilter(), nodeType18.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode, T18 : AbstractInsnNode, T19 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, filter15: InstructionNodeFilter<T15>, filter16: InstructionNodeFilter<T16>, filter17: InstructionNodeFilter<T17>, filter18: InstructionNodeFilter<T18>, filter19: InstructionNodeFilter<T19>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17, node18: T18, node19: T19) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 19) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 19) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null
    var node15: T15? = null
    var node16: T16? = null
    var node17: T17? = null
    var node18: T18? = null
    var node19: T19? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
        node15 = null
        node16 = null
        node17 = null
        node18 = null
        node19 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()
            } else if (null == node15) {
                if (!filter15.nodeType.isInstance(node)) return@run reset()
                filter15.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node15 = node.uncheckedCast()
            } else if (null == node16) {
                if (!filter16.nodeType.isInstance(node)) return@run reset()
                filter16.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node16 = node.uncheckedCast()
            } else if (null == node17) {
                if (!filter17.nodeType.isInstance(node)) return@run reset()
                filter17.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node17 = node.uncheckedCast()
            } else if (null == node18) {
                if (!filter18.nodeType.isInstance(node)) return@run reset()
                filter18.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node18 = node.uncheckedCast()
            } else if (null == node19) {
                if (!filter19.nodeType.isInstance(node)) return@run reset()
                filter19.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node19 = node.uncheckedCast()

                nextNode = node19!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!, node15!!, node16!!, node17!!, node18!!, node19!!)
                if (1 <= newInstructions.size()) instructions.insert(node19, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node19) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode, T18 : AbstractInsnNode, T19 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, nodeType15: Class<T15>, nodeType16: Class<T16>, nodeType17: Class<T17>, nodeType18: Class<T18>, nodeType19: Class<T19>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17, node18: T18, node19: T19) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), nodeType15.toInstructionNodeFilter(), nodeType16.toInstructionNodeFilter(), nodeType17.toInstructionNodeFilter(), nodeType18.toInstructionNodeFilter(), nodeType19.toInstructionNodeFilter(), instructionsGenerator)


fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode, T18 : AbstractInsnNode, T19 : AbstractInsnNode, T20 : AbstractInsnNode> MethodNode.replaceInstructions(filter1: InstructionNodeFilter<T1>, filter2: InstructionNodeFilter<T2>, filter3: InstructionNodeFilter<T3>, filter4: InstructionNodeFilter<T4>, filter5: InstructionNodeFilter<T5>, filter6: InstructionNodeFilter<T6>, filter7: InstructionNodeFilter<T7>, filter8: InstructionNodeFilter<T8>, filter9: InstructionNodeFilter<T9>, filter10: InstructionNodeFilter<T10>, filter11: InstructionNodeFilter<T11>, filter12: InstructionNodeFilter<T12>, filter13: InstructionNodeFilter<T13>, filter14: InstructionNodeFilter<T14>, filter15: InstructionNodeFilter<T15>, filter16: InstructionNodeFilter<T16>, filter17: InstructionNodeFilter<T17>, filter18: InstructionNodeFilter<T18>, filter19: InstructionNodeFilter<T19>, filter20: InstructionNodeFilter<T20>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17, node18: T18, node19: T19, node20: T20) -> InsnList): Boolean {
    val instructions = this.instructions ?: return false
    if (instructions.size() < 20) return false

    val unusedLabelNodes = this.unusedLabelNodes
    if (instructions.size() - unusedLabelNodes.size < 20) return false

    fun canBeUsed(node: AbstractInsnNode) = node !is LineNumberNode && node !in unusedLabelNodes

    var node1: T1? = null
    var node2: T2? = null
    var node3: T3? = null
    var node4: T4? = null
    var node5: T5? = null
    var node6: T6? = null
    var node7: T7? = null
    var node8: T8? = null
    var node9: T9? = null
    var node10: T10? = null
    var node11: T11? = null
    var node12: T12? = null
    var node13: T13? = null
    var node14: T14? = null
    var node15: T15? = null
    var node16: T16? = null
    var node17: T17? = null
    var node18: T18? = null
    var node19: T19? = null
    var node20: T20? = null

    fun reset() {
        node1 = null
        node2 = null
        node3 = null
        node4 = null
        node5 = null
        node6 = null
        node7 = null
        node8 = null
        node9 = null
        node10 = null
        node11 = null
        node12 = null
        node13 = null
        node14 = null
        node15 = null
        node16 = null
        node17 = null
        node18 = null
        node19 = null
        node20 = null
    }

    var curNode: AbstractInsnNode? = instructions.first ?: return false
    var isSomethingChanged = false
    while (null != curNode) {
        val node: AbstractInsnNode = curNode
        var nextNode: AbstractInsnNode? = node.next
        run {
            if (!canBeUsed(node)) return@run
            if (null == node1) {
                if (!filter1.nodeType.isInstance(node)) return@run reset()
                filter1.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node1 = node.uncheckedCast()
            } else if (null == node2) {
                if (!filter2.nodeType.isInstance(node)) return@run reset()
                filter2.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node2 = node.uncheckedCast()
            } else if (null == node3) {
                if (!filter3.nodeType.isInstance(node)) return@run reset()
                filter3.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node3 = node.uncheckedCast()
            } else if (null == node4) {
                if (!filter4.nodeType.isInstance(node)) return@run reset()
                filter4.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node4 = node.uncheckedCast()
            } else if (null == node5) {
                if (!filter5.nodeType.isInstance(node)) return@run reset()
                filter5.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node5 = node.uncheckedCast()
            } else if (null == node6) {
                if (!filter6.nodeType.isInstance(node)) return@run reset()
                filter6.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node6 = node.uncheckedCast()
            } else if (null == node7) {
                if (!filter7.nodeType.isInstance(node)) return@run reset()
                filter7.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node7 = node.uncheckedCast()
            } else if (null == node8) {
                if (!filter8.nodeType.isInstance(node)) return@run reset()
                filter8.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node8 = node.uncheckedCast()
            } else if (null == node9) {
                if (!filter9.nodeType.isInstance(node)) return@run reset()
                filter9.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node9 = node.uncheckedCast()
            } else if (null == node10) {
                if (!filter10.nodeType.isInstance(node)) return@run reset()
                filter10.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node10 = node.uncheckedCast()
            } else if (null == node11) {
                if (!filter11.nodeType.isInstance(node)) return@run reset()
                filter11.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node11 = node.uncheckedCast()
            } else if (null == node12) {
                if (!filter12.nodeType.isInstance(node)) return@run reset()
                filter12.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node12 = node.uncheckedCast()
            } else if (null == node13) {
                if (!filter13.nodeType.isInstance(node)) return@run reset()
                filter13.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node13 = node.uncheckedCast()
            } else if (null == node14) {
                if (!filter14.nodeType.isInstance(node)) return@run reset()
                filter14.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node14 = node.uncheckedCast()
            } else if (null == node15) {
                if (!filter15.nodeType.isInstance(node)) return@run reset()
                filter15.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node15 = node.uncheckedCast()
            } else if (null == node16) {
                if (!filter16.nodeType.isInstance(node)) return@run reset()
                filter16.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node16 = node.uncheckedCast()
            } else if (null == node17) {
                if (!filter17.nodeType.isInstance(node)) return@run reset()
                filter17.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node17 = node.uncheckedCast()
            } else if (null == node18) {
                if (!filter18.nodeType.isInstance(node)) return@run reset()
                filter18.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node18 = node.uncheckedCast()
            } else if (null == node19) {
                if (!filter19.nodeType.isInstance(node)) return@run reset()
                filter19.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node19 = node.uncheckedCast()
            } else if (null == node20) {
                if (!filter20.nodeType.isInstance(node)) return@run reset()
                filter20.predicate.let { if (null != it && !it(InstructionNodeContext(node.uncheckedCast(), node.getPrevious(::canBeUsed), node.getNext(::canBeUsed)))) return@run reset() }
                node20 = node.uncheckedCast()

                nextNode = node20!!.next
                val newInstructions = instructionsGenerator(node1!!, node2!!, node3!!, node4!!, node5!!, node6!!, node7!!, node8!!, node9!!, node10!!, node11!!, node12!!, node13!!, node14!!, node15!!, node16!!, node17!!, node18!!, node19!!, node20!!)
                if (1 <= newInstructions.size()) instructions.insert(node20, newInstructions)
                var nodeToDelete: AbstractInsnNode = node1!!
                while (true) {
                    val next = nodeToDelete.next ?: break
                    instructions.remove(nodeToDelete)
                    if (nodeToDelete == node20) break
                    nodeToDelete = next
                }
                isSomethingChanged = true
                reset()
            }
        }
        curNode = nextNode
    }
    return isSomethingChanged
}

fun <T1 : AbstractInsnNode, T2 : AbstractInsnNode, T3 : AbstractInsnNode, T4 : AbstractInsnNode, T5 : AbstractInsnNode, T6 : AbstractInsnNode, T7 : AbstractInsnNode, T8 : AbstractInsnNode, T9 : AbstractInsnNode, T10 : AbstractInsnNode, T11 : AbstractInsnNode, T12 : AbstractInsnNode, T13 : AbstractInsnNode, T14 : AbstractInsnNode, T15 : AbstractInsnNode, T16 : AbstractInsnNode, T17 : AbstractInsnNode, T18 : AbstractInsnNode, T19 : AbstractInsnNode, T20 : AbstractInsnNode> MethodNode.replaceInstructions(nodeType1: Class<T1>, nodeType2: Class<T2>, nodeType3: Class<T3>, nodeType4: Class<T4>, nodeType5: Class<T5>, nodeType6: Class<T6>, nodeType7: Class<T7>, nodeType8: Class<T8>, nodeType9: Class<T9>, nodeType10: Class<T10>, nodeType11: Class<T11>, nodeType12: Class<T12>, nodeType13: Class<T13>, nodeType14: Class<T14>, nodeType15: Class<T15>, nodeType16: Class<T16>, nodeType17: Class<T17>, nodeType18: Class<T18>, nodeType19: Class<T19>, nodeType20: Class<T20>, instructionsGenerator: (node1: T1, node2: T2, node3: T3, node4: T4, node5: T5, node6: T6, node7: T7, node8: T8, node9: T9, node10: T10, node11: T11, node12: T12, node13: T13, node14: T14, node15: T15, node16: T16, node17: T17, node18: T18, node19: T19, node20: T20) -> InsnList) = replaceInstructions(nodeType1.toInstructionNodeFilter(), nodeType2.toInstructionNodeFilter(), nodeType3.toInstructionNodeFilter(), nodeType4.toInstructionNodeFilter(), nodeType5.toInstructionNodeFilter(), nodeType6.toInstructionNodeFilter(), nodeType7.toInstructionNodeFilter(), nodeType8.toInstructionNodeFilter(), nodeType9.toInstructionNodeFilter(), nodeType10.toInstructionNodeFilter(), nodeType11.toInstructionNodeFilter(), nodeType12.toInstructionNodeFilter(), nodeType13.toInstructionNodeFilter(), nodeType14.toInstructionNodeFilter(), nodeType15.toInstructionNodeFilter(), nodeType16.toInstructionNodeFilter(), nodeType17.toInstructionNodeFilter(), nodeType18.toInstructionNodeFilter(), nodeType19.toInstructionNodeFilter(), nodeType20.toInstructionNodeFilter(), instructionsGenerator)

