package name.remal

import org.objectweb.asm.tree.AbstractInsnNode
import org.objectweb.asm.tree.InsnList

fun InsnList.isEmpty() = 0 == size()
fun InsnList.isNotEmpty() = !isEmpty()
fun InsnList?.isNullOrEmpty() = null == this || isEmpty()

inline fun InsnList.forEach(action: (node: AbstractInsnNode) -> Unit) {
    var node = first
    while (null != node) {
        action(node)
        node = node.next
    }
}

fun InsnList.toList() = buildList<AbstractInsnNode> {
    this@toList.forEach { add(it) }
}
