package name.remal

import org.objectweb.asm.tree.AbstractInsnNode

fun AbstractInsnNode.getPrevious(predicate: (node: AbstractInsnNode) -> Boolean): AbstractInsnNode? {
    var node = previous
    while (null != node) {
        if (predicate(node)) return node
        node = node.previous
    }
    return null
}

fun AbstractInsnNode.getNext(predicate: (node: AbstractInsnNode) -> Boolean): AbstractInsnNode? {
    var node = next
    while (null != node) {
        if (predicate(node)) return node
        node = node.next
    }
    return null
}
