package name.remal.log;
import org.jetbrains.annotations.NotNull;
public class LogUtils {

    public static void logTrace(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).trace(message); }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull String message) {
        logTrace(loggerClass.getName(), message);
    }

    public static void logTrace(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).trace(message, throwable); }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        logTrace(loggerClass.getName(), message, throwable);
    }

    public static void logTrace(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).trace(throwable.getMessage(), throwable); }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        logTrace(loggerClass.getName(), throwable);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).debug(message); }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull String message) {
        logDebug(loggerClass.getName(), message);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).debug(message, throwable); }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        logDebug(loggerClass.getName(), message, throwable);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).debug(throwable.getMessage(), throwable); }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        logDebug(loggerClass.getName(), throwable);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).info(message); }
        else { System.out.println(message); }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull String message) {
        logInfo(loggerClass.getName(), message);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).info(message, throwable); }
        else { System.out.println(message); System.out.println(throwable.toString()); }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        logInfo(loggerClass.getName(), message, throwable);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).info(throwable.getMessage(), throwable); }
        else { System.out.println(throwable.toString()); }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        logInfo(loggerClass.getName(), throwable);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).warn(message); }
        else { System.err.println(message); }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull String message) {
        logWarn(loggerClass.getName(), message);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).warn(message, throwable); }
        else { System.err.println(message); System.err.println(throwable.toString()); }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        logWarn(loggerClass.getName(), message, throwable);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).warn(throwable.getMessage(), throwable); }
        else { System.err.println(throwable.toString()); }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        logWarn(loggerClass.getName(), throwable);
    }

    public static void logError(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).error(message); }
        else { System.err.println(message); }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull String message) {
        logError(loggerClass.getName(), message);
    }

    public static void logError(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).error(message, throwable); }
        else { System.err.println(message); System.err.println(throwable.toString()); }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        logError(loggerClass.getName(), message, throwable);
    }

    public static void logError(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) { org.slf4j.LoggerFactory.getLogger(loggerName).error(throwable.getMessage(), throwable); }
        else { System.err.println(throwable.toString()); }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        logError(loggerClass.getName(), throwable);
    }

    private static final boolean IS_SLF4J_IN_CLASSPATH = isSlf4JInClasspath();

    private static boolean isSlf4JInClasspath() {
        try {
            Class.forName("org.slf4j.LoggerFactory");
            return true;
        } catch (ClassNotFoundException e) {
            return false;
        }
    }

}
