package name.remal

import java.util.concurrent.atomic.AtomicLong

fun AtomicLong.incrementAndGetUnsigned(): Long {
    while (true) {
        val result = incrementAndGet()
        if (0 <= result) return result
        if (compareAndSet(result, 0)) {
            return 0
        }
    }
}

fun AtomicLong.decrementAndGetUnsigned(): Long {
    while (true) {
        val result = decrementAndGet()
        if (0 <= result) return result
        if (compareAndSet(result, Long.MAX_VALUE)) {
            return Long.MAX_VALUE
        }
    }
}
