package name.remal

import java.util.concurrent.atomic.AtomicInteger

fun AtomicInteger.incrementAndGetUnsigned(): Int {
    while (true) {
        val result = incrementAndGet()
        if (0 <= result) return result
        if (compareAndSet(result, 0)) {
            return 0
        }
    }
}

fun AtomicInteger.decrementAndGetUnsigned(): Int {
    while (true) {
        val result = decrementAndGet()
        if (0 <= result) return result
        if (compareAndSet(result, Int.MAX_VALUE)) {
            return Int.MAX_VALUE
        }
    }
}
