package name.remal

import java.io.*
import java.util.*
import kotlin.text.Charsets.UTF_8

@Deprecated("Use string keys and values")
operator fun Properties.set(key: Any?, value: Any?) = put(key, value)

operator fun Properties.set(key: String, value: String?): String? {
    if (null == value) {
        val prevValue = getProperty(key)
        remove(key)
        return prevValue

    } else {
        val prevValue = getProperty(key)
        setProperty(key, value)
        return prevValue
    }
}


fun loadProperties(file: File) = Properties().apply { load(file) }
fun loadProperties(content: String) = Properties().apply { load(content) }
fun loadProperties(content: InputStream) = Properties().apply { load(content) }
fun loadProperties(content: Reader) = Properties().apply { load(content) }

fun Properties.load(file: File) {
    file.inputStream().use { load(it) }
}

fun Properties.load(content: String) {
    StringReader(content).use { load(it) }
}

fun Properties.storeAsString(doStripComments: Boolean = true): String {
    var content = StringWriter().use { store(it, ""); it.toString() }
    if (doStripComments) {
        content = content.splitToSequence('\n')
            .map { it.substringBefore('#').trim() }
            .filter(String::isNotEmpty)
            .joinToString("\n")
    }
    return content
}

fun Properties.store(file: File, doStripComments: Boolean = true) {
    file.createParentDirectories().writeText(storeAsString(doStripComments), UTF_8)
}

