package name.remal

import name.remal.reflection.ClassLoaderUtils
import java.io.File
import java.net.URL
import java.nio.file.Path

fun ClassLoader.getPackageOrNull(packageName: String) = ClassLoaderUtils.getPackageOrNull(this, packageName)

fun ClassLoader.tryLoadClass(className: String, initialize: Boolean = false): Class<*>? = try {
    Class.forName(className, initialize, this)
} catch (ignored: LinkageError) {
    null
} catch (ignored: ClassNotFoundException) {
    null
}

fun ClassLoader.addURL(vararg urls: URL) = ClassLoaderUtils.addURLsToClassLoader(this, *urls)
fun ClassLoader.addURL(vararg files: File) = addURL(*files.map { it.toURI().toURL() }.toTypedArray())
fun ClassLoader.addURL(vararg paths: Path) = addURL(*paths.map { it.toUri().toURL() }.toTypedArray())


fun <T, R> ClassLoader.forInstantiated(type: Class<T>, implementationType: Class<out T>, action: (T) -> R): R = ClassLoaderUtils.forInstantiated(this, type, implementationType, action)
