package name.remal.annotation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Objects;

final class MetaAnnotationScanContext {

    @NotNull
    private final AnnotatedElement annotatedElement;

    @Nullable
    private final List<@NotNull AnnotationAttribute> attributes;

    public MetaAnnotationScanContext(@NotNull AnnotatedElement annotatedElement, @Nullable List<@NotNull AnnotationAttribute> attributes) {
        this.annotatedElement = annotatedElement;
        this.attributes = attributes;
    }

    @NotNull
    public AnnotatedElement getAnnotatedElement() {
        return annotatedElement;
    }

    @Nullable
    public List<@NotNull AnnotationAttribute> getAttributes() {
        return attributes;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MetaAnnotationScanContext)) return false;
        MetaAnnotationScanContext other = (MetaAnnotationScanContext) obj;
        return Objects.equals(annotatedElement, other.annotatedElement) && Objects.equals(attributes, other.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(annotatedElement, attributes);
    }

    @Override
    public String toString() {
        return MetaAnnotationScanContext.class.getSimpleName() + "{"
            + "annotatedElement=" + annotatedElement
            + ", attributes=" + attributes
            + '}';
    }

}
