package name.remal.annotation;

import org.jetbrains.annotations.NotNull;

import java.lang.annotation.*;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Repeatable(AnnotationAttributeAlias.List.class)
@Target(METHOD)
@Retention(RUNTIME)
public @interface AnnotationAttributeAlias {

    @NotNull Class<? extends Annotation> annotationClass();

    @NotNull String attributeName();

    @Documented
    @Target(METHOD)
    @Retention(RUNTIME)
    @interface List {
        @NotNull AnnotationAttributeAlias[] value() default {};
    }

}
