package name.remal.annotation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.annotation.Annotation;
import java.util.Objects;

import static name.remal.ArrayUtils.*;

class AnnotationAttribute {

    @NotNull
    private final Class<? extends Annotation> annotationType;

    @NotNull
    private final String name;

    @Nullable
    private final Object value;

    public AnnotationAttribute(@NotNull Class<? extends Annotation> annotationType, @NotNull String name, @Nullable Object value) {
        this.annotationType = annotationType;
        this.name = name;
        this.value = value;
    }

    @NotNull
    public Class<? extends Annotation> getAnnotationType() {
        return annotationType;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @Nullable
    public Object getValue() {
        return value;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof AnnotationAttribute)) return false;
        AnnotationAttribute other = (AnnotationAttribute) object;
        return Objects.equals(annotationType, other.annotationType)
            && Objects.equals(name, other.name)
            && arrayEquals(value, other.value);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + annotationType.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + arrayHashCode(value);
        return result;
    }

    @NotNull
    @Override
    public String toString() {
        return AnnotationAttribute.class.getSimpleName() + '('
            + "annotationType=" + annotationType
            + ", name='" + name + '\''
            + ", value=" + arrayToString(value)
            + '}';
    }

}
